/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.google.common.collect.ImmutableSet;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockWorldRegistry;
import forestry.core.utils.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class MultiblockRegistry {
    private static final Map<IWorld, MultiblockWorldRegistry> registries = new HashMap<IWorld, MultiblockWorldRegistry>();

    public static void tickStart(IWorld world) {
        if (registries.containsKey(world)) {
            MultiblockWorldRegistry registry = registries.get(world);
            registry.processMultiblockChanges();
            registry.tickStart();
        }
    }

    public static void onChunkLoaded(IWorld world, int chunkX, int chunkZ) {
        if (registries.containsKey(world)) {
            registries.get(world).onChunkLoaded(chunkX, chunkZ);
        }
    }

    public static void onPartAdded(World world, IMultiblockComponent part) {
        MultiblockWorldRegistry registry = MultiblockRegistry.getOrCreateRegistry(world);
        registry.onPartAdded(part);
    }

    public static void onPartRemovedFromWorld(World world, IMultiblockComponent part) {
        if (registries.containsKey(world)) {
            registries.get(world).onPartRemovedFromWorld(part);
        }
    }

    public static void onWorldUnloaded(IWorld world) {
        if (registries.containsKey(world)) {
            registries.get(world).onWorldUnloaded();
            registries.remove(world);
        }
    }

    public static void addDirtyController(IWorld world, IMultiblockControllerInternal controller) {
        if (!registries.containsKey(world)) {
            throw new IllegalArgumentException("Adding a dirty controller to a world that has no registered controllers!");
        }
        registries.get(world).addDirtyController(controller);
    }

    public static void addDeadController(IWorld world, IMultiblockControllerInternal controller) {
        if (registries.containsKey(world)) {
            registries.get(world).addDeadController(controller);
        } else {
            Log.warning("Controller {} in world {} marked as dead, but that world is not tracked! Controller is being ignored.", controller.hashCode(), world);
        }
    }

    public static Set<IMultiblockControllerInternal> getControllersFromWorld(IWorld world) {
        if (registries.containsKey(world)) {
            return registries.get(world).getControllers();
        }
        return ImmutableSet.of();
    }

    private static MultiblockWorldRegistry getOrCreateRegistry(World world) {
        if (registries.containsKey(world)) {
            return registries.get(world);
        }
        MultiblockWorldRegistry newRegistry = new MultiblockWorldRegistry(world);
        registries.put((IWorld)world, newRegistry);
        return newRegistry;
    }
}

