/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.IStreamable;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import java.io.IOException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PacketTileStream
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final IStreamable streamable;

    public <T extends TileEntity> PacketTileStream(T streamable) {
        this.pos = streamable.func_174877_v();
        this.streamable = (IStreamable)streamable;
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.TILE_FORESTRY_UPDATE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        this.streamable.writeData(data);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, PlayerEntity player) throws IOException {
            BlockPos pos = data.func_179259_c();
            IStreamable tile = TileUtil.getTile((IBlockReader)player.field_70170_p, pos, IStreamable.class);
            if (tile != null) {
                tile.readData(data);
            }
        }
    }
}

