/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.patchouli.processor;

import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class CarpenterProcessor
implements IComponentProcessor {
    protected ICarpenterRecipe recipe;

    public void setup(IVariableProvider variables) {
        ItemStack itemStack;
        int index;
        try {
            index = variables.get("index").asNumber().intValue();
        }
        catch (Exception e) {
            index = 0;
        }
        try {
            itemStack = (ItemStack)variables.get("item").as(ItemStack.class);
        }
        catch (Exception e) {
            itemStack = ItemStack.field_190927_a;
        }
        ArrayList<ICarpenterRecipe> matches = new ArrayList<ICarpenterRecipe>();
        for (ICarpenterRecipe icr : RecipeManagers.carpenterManager.getRecipes(null)) {
            ItemStack result = icr.getResult();
            if (result.func_77973_b() != itemStack.func_77973_b()) continue;
            matches.add(icr);
            break;
        }
        this.recipe = (ICarpenterRecipe)matches.get(index);
    }

    public IVariable process(String key) {
        if (key.equals("output")) {
            return IVariable.from((Object)this.recipe.getResult());
        }
        if (key.equals("fluid")) {
            return IVariable.wrap((String)this.recipe.getFluidResource().getFluid().getRegistryName().toString());
        }
        if (key.equals("fluidAmount")) {
            return IVariable.wrap((Number)this.recipe.getFluidResource().getAmount());
        }
        if (key.startsWith("ingredient")) {
            Ingredient ingredient;
            int index = Integer.parseInt(key.substring("ingredient".length()));
            if (index < 1 || index > 9) {
                return IVariable.empty();
            }
            try {
                ingredient = (Ingredient)this.recipe.getCraftingGridRecipe().func_192400_c().get(index - 1);
            }
            catch (Exception e) {
                ingredient = Ingredient.field_193370_a;
            }
            return IVariable.from((Object)ingredient.func_193365_a());
        }
        return IVariable.empty();
    }
}

