/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.patchouli.processor;

import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class FabricatorProcessor
implements IComponentProcessor {
    protected IFabricatorRecipe recipe;

    public void setup(IVariableProvider variables) {
        ItemStack itemStack;
        int index;
        try {
            index = variables.get("index").asNumber().intValue();
        }
        catch (Exception e) {
            index = 0;
        }
        try {
            itemStack = (ItemStack)variables.get("item").as(ItemStack.class);
        }
        catch (Exception e) {
            itemStack = ItemStack.field_190927_a;
        }
        ArrayList<IFabricatorRecipe> matches = new ArrayList<IFabricatorRecipe>();
        for (IFabricatorRecipe ifr : RecipeManagers.fabricatorManager.getRecipes(null)) {
            ItemStack result = ifr.getCraftingGridRecipe().func_77571_b();
            if (result.func_77973_b() != itemStack.func_77973_b()) continue;
            matches.add(ifr);
            break;
        }
        this.recipe = (IFabricatorRecipe)matches.get(index);
    }

    public IVariable process(String key) {
        if (key.equals("output")) {
            return IVariable.from((Object)this.recipe.getCraftingGridRecipe().func_77571_b());
        }
        if (key.equals("fluid")) {
            return IVariable.wrap((String)this.recipe.getLiquid().getFluid().getRegistryName().toString());
        }
        if (key.equals("fluidAmount")) {
            return IVariable.wrap((Number)this.recipe.getLiquid().getAmount());
        }
        if (key.startsWith("ingredient")) {
            Ingredient ingredient;
            int index = Integer.parseInt(key.substring("ingredient".length()));
            if (index < 1 || index > 9) {
                return IVariable.empty();
            }
            try {
                ingredient = (Ingredient)this.recipe.getCraftingGridRecipe().func_192400_c().get(index - 1);
            }
            catch (Exception e) {
                ingredient = Ingredient.field_193370_a;
            }
            return IVariable.from((Object)ingredient.func_193365_a());
        }
        if (key.equals("plan")) {
            return IVariable.from((Object)this.recipe.getPlan());
        }
        if (key.equals("metal")) {
            if (this.recipe.getLiquid().getFluid().getRegistryName().func_110623_a().contains("glass")) {
                return IVariable.from((Object)new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft:sand"))));
            }
            ArrayList results = new ArrayList();
            for (IFabricatorSmeltingRecipe r : RecipeManagers.fabricatorSmeltingManager.getRecipes(null)) {
                if (!r.getProduct().isFluidEqual(this.recipe.getLiquid())) continue;
                Collections.addAll(results, r.getResource().func_193365_a());
            }
            return IVariable.from(results.get(0));
        }
        return IVariable.empty();
    }
}

