/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.core.blocks.BlockBase;
import forestry.core.blocks.IBlockType;
import forestry.core.tiles.TileForestry;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class TileBase
extends TileForestry {
    public TileBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void openGui(ServerPlayerEntity player, BlockPos pos) {
        if (!this.hasGui()) {
            return;
        }
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, (BlockPos)pos);
    }

    protected boolean hasGui() {
        return true;
    }

    @Override
    public String getUnlocalizedTitle() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof BlockBase) {
            return block.func_149739_a();
        }
        return super.getUnlocalizedTitle();
    }

    public <T extends IBlockType> T getBlockType(T fallbackType) {
        BlockState blockState = this.func_195044_w();
        Block block = blockState.func_177230_c();
        if (!(block instanceof BlockBase)) {
            return fallbackType;
        }
        BlockBase blockBase = (BlockBase)block;
        return (T)((IBlockType)blockBase.blockType);
    }

    @Nonnull
    public Direction getFacing() {
        return (Direction)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b(BlockBase.FACING);
    }
}

