/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.core.gui.ContainerNaturalistInventory;
import forestry.core.gui.IPagedInventory;
import forestry.core.inventory.InventoryNaturalistChest;
import forestry.core.network.PacketBufferForestry;
import forestry.core.tiles.TileBase;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class TileNaturalistChest
extends TileBase
implements IPagedInventory {
    private static final float lidAngleVariationPerTick = 0.1f;
    public static final VoxelShape CHEST_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private final IForestrySpeciesRoot speciesRoot;
    public float lidAngle;
    public float prevLidAngle;
    private int numPlayersUsing;

    public TileNaturalistChest(TileEntityType type, IForestrySpeciesRoot speciesRoot) {
        super(type);
        this.speciesRoot = speciesRoot;
        this.setInternalInventory(new InventoryNaturalistChest(this, speciesRoot));
    }

    public void increaseNumPlayersUsing() {
        ++this.numPlayersUsing;
        this.setNeedsNetworkUpdate();
    }

    public void decreaseNumPlayersUsing() {
        --this.numPlayersUsing;
        if (this.numPlayersUsing < 0) {
            this.numPlayersUsing = 0;
        }
        this.setNeedsNetworkUpdate();
    }

    @Override
    protected void updateClientSide() {
        this.updates();
    }

    @Override
    protected void updateServerSide() {
        this.updates();
    }

    private void updates() {
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            this.playLidSound(SoundEvents.field_187657_V);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float oldAngle = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            this.lidAngle = Math.max(Math.min(this.lidAngle, 1.0f), 0.0f);
            if (this.lidAngle < 0.5f && oldAngle >= 0.5f) {
                this.playLidSound(SoundEvents.field_187651_T);
            }
        }
    }

    private void playLidSound(SoundEvent sound) {
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), sound, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    @Override
    public void flipPage(ServerPlayerEntity player, short page) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, p -> {
            p.func_179255_a(this.field_174879_c);
            p.func_150787_b((int)page);
        });
    }

    @Override
    public void openGui(ServerPlayerEntity player, BlockPos pos) {
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, p -> {
            p.func_179255_a(this.field_174879_c);
            p.func_150787_b(0);
        });
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        data.writeInt(this.numPlayersUsing);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.numPlayersUsing = data.readInt();
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerNaturalistInventory(windowId, inv, this, 5);
    }

    public IForestrySpeciesRoot getSpeciesRoot() {
        return this.speciesRoot;
    }
}

