/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.core.utils.Log;
import forestry.modules.features.FeatureItem;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class JeiUtil {
    public static final String DESCRIPTION_KEY = "for.jei.description.";

    private JeiUtil() {
    }

    public static void addDescription(IRecipeRegistration registry, String itemKey, FeatureItem ... items) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (FeatureItem item : items) {
            itemStacks.add(item.stack());
        }
        registry.addIngredientInfo(itemStacks, VanillaTypes.ITEM, new String[]{DESCRIPTION_KEY + itemKey});
    }

    public static void addDescription(IRecipeRegistration registry, String itemKey, Item ... items) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (Item item : items) {
            itemStacks.add(new ItemStack((IItemProvider)item));
        }
        registry.addIngredientInfo(itemStacks, VanillaTypes.ITEM, new String[]{DESCRIPTION_KEY + itemKey});
    }

    public static void addDescription(IRecipeRegistration registry, Block ... blocks) {
        for (Block block : blocks) {
            Item item = Item.func_150898_a((Block)block);
            if (item != Items.field_190931_a) {
                JeiUtil.addDescription(registry, item);
                continue;
            }
            Log.error("No item for block {}", block);
        }
    }

    public static void addDescription(IRecipeRegistration registry, FeatureItem ... items) {
        for (FeatureItem item : items) {
            JeiUtil.addDescription(registry, item.get());
        }
    }

    public static void addDescription(IRecipeRegistration registry, Item ... items) {
        for (Item item : items) {
            JeiUtil.addDescription(registry, item);
        }
    }

    public static void addDescription(IRecipeRegistration registry, Item item) {
        String resourcePath = item.getRegistryName().func_110623_a();
        JeiUtil.addDescription(registry, item, resourcePath);
    }

    public static void addDescription(IRecipeRegistration registry, Item item, String itemKey) {
        ItemStack itemStack = new ItemStack((IItemProvider)item);
        registry.addIngredientInfo((Object)itemStack, VanillaTypes.ITEM, new String[]{DESCRIPTION_KEY + itemKey});
    }
}

