/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.blocks;

import forestry.core.blocks.BlockBase;
import forestry.core.tiles.TileUtil;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyManager;
import forestry.energy.blocks.BlockTypeEngine;
import forestry.energy.tiles.TileEngine;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BlockEngine
extends BlockBase<BlockTypeEngine> {
    private static final EnumMap<Direction, VoxelShape> SHAPE_FOR_DIRECTIONS = new EnumMap(Direction.class);

    public BlockEngine(BlockTypeEngine blockType) {
        super(blockType, AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).harvestTool(ToolType.PICKAXE).harvestLevel(0));
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> stacks) {
        if (this.blockType == BlockTypeEngine.CLOCKWORK) {
            // empty if block
        }
        super.func_149666_a(group, stacks);
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        Direction orientation = (Direction)state.func_177229_b((Property)FACING);
        return SHAPE_FOR_DIRECTIONS.get(orientation);
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation rot) {
        return BlockEngine.rotate(state, world, pos);
    }

    private static boolean isOrientedAtEnergyReciever(IWorld world, BlockPos pos, Direction orientation) {
        BlockPos offsetPos = pos.func_177972_a(orientation);
        TileEntity tile = TileUtil.getTile((IBlockReader)world, offsetPos);
        return EnergyHelper.isEnergyReceiverOrEngine(orientation.func_176734_d(), tile);
    }

    private static BlockState rotate(BlockState state, IWorld world, BlockPos pos) {
        Direction blockFacing = (Direction)state.func_177229_b((Property)FACING);
        for (int i = blockFacing.ordinal() + 1; i <= blockFacing.ordinal() + 6; ++i) {
            Direction orientation = Direction.values()[i % 6];
            if (!BlockEngine.isOrientedAtEnergyReciever(world, pos, orientation)) continue;
            return (BlockState)state.func_206870_a((Property)FACING, (Comparable)orientation);
        }
        return state;
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        Direction orientation = context.func_196000_l().func_176734_d();
        World world = context.func_195991_k();
        if (BlockEngine.isOrientedAtEnergyReciever((IWorld)world, pos = context.func_195995_a(), orientation)) {
            return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)orientation);
        }
        return BlockEngine.rotate((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f()), (IWorld)world, pos);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEngine tileEngine = TileUtil.getTile((IBlockReader)worldIn, pos, TileEngine.class);
        if (tileEngine != null) {
            EnergyManager energyManager = tileEngine.getEnergyManager();
            return energyManager.calculateRedstone();
        }
        return 0;
    }

    static {
        SHAPE_FOR_DIRECTIONS.put(Direction.EAST, VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.0, (double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0), Block.func_208617_a((double)10.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0)}));
        SHAPE_FOR_DIRECTIONS.put(Direction.WEST, VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)6.0, (double)12.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)6.0, (double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0), Block.func_208617_a((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)}));
        SHAPE_FOR_DIRECTIONS.put(Direction.SOUTH, VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)14.0, (double)10.0), Block.func_208617_a((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)16.0)}));
        SHAPE_FOR_DIRECTIONS.put(Direction.NORTH, VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)14.0, (double)10.0), Block.func_208617_a((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0)}));
        SHAPE_FOR_DIRECTIONS.put(Direction.UP, VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.func_208617_a((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)}));
        SHAPE_FOR_DIRECTIONS.put(Direction.DOWN, VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0)}));
    }
}

