/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory;

import com.google.common.collect.Maps;
import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.GeneratorFuel;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.fuels.RainSubstrate;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.core.circuits.CircuitLayout;
import forestry.core.circuits.Circuits;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.features.CoreItems;
import forestry.core.fluids.ForestryFluids;
import forestry.core.items.definitions.EnumCraftingMaterial;
import forestry.core.items.definitions.EnumElectronTube;
import forestry.core.network.IPacketRegistry;
import forestry.core.utils.ForgeUtils;
import forestry.core.utils.datastructures.DummyMap;
import forestry.core.utils.datastructures.FluidMap;
import forestry.core.utils.datastructures.ItemStackMap;
import forestry.factory.DummyManagers;
import forestry.factory.MachineUIDs;
import forestry.factory.circuits.CircuitSpeedUpgrade;
import forestry.factory.features.FactoryContainers;
import forestry.factory.gui.GuiBottler;
import forestry.factory.gui.GuiCarpenter;
import forestry.factory.gui.GuiCentrifuge;
import forestry.factory.gui.GuiFabricator;
import forestry.factory.gui.GuiFermenter;
import forestry.factory.gui.GuiMoistener;
import forestry.factory.gui.GuiRaintank;
import forestry.factory.gui.GuiSqueezer;
import forestry.factory.gui.GuiStill;
import forestry.factory.network.PacketRegistryFactory;
import forestry.factory.recipes.CarpenterRecipeManager;
import forestry.factory.recipes.CentrifugeRecipeManager;
import forestry.factory.recipes.FabricatorRecipeManager;
import forestry.factory.recipes.FabricatorSmeltingRecipeManager;
import forestry.factory.recipes.FermenterRecipeManager;
import forestry.factory.recipes.MoistenerRecipeManager;
import forestry.factory.recipes.SqueezerContainerRecipeManager;
import forestry.factory.recipes.SqueezerRecipeManager;
import forestry.factory.recipes.StillRecipeManager;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@ForestryModule(containerID="forestry", moduleID="factory", name="Factory", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.factory.description", lootTable="factory")
public class ModuleFactory
extends BlankForestryModule {
    public static final Map<String, Boolean> MACHINE_ENABLED = Maps.newHashMap();

    public ModuleFactory() {
        ForgeUtils.registerSubscriber(this);
    }

    @Override
    public void setupAPI() {
        RecipeManagers.carpenterManager = ModuleFactory.machineEnabled("carpenter") ? new CarpenterRecipeManager() : new DummyManagers.DummyCarpenterManager();
        RecipeManagers.centrifugeManager = ModuleFactory.machineEnabled("centrifuge") ? new CentrifugeRecipeManager() : new DummyManagers.DummyCentrifugeManager();
        RecipeManagers.fabricatorManager = ModuleFactory.machineEnabled("fabricator") ? new FabricatorRecipeManager() : new DummyManagers.DummyFabricatorManager();
        RecipeManagers.fabricatorSmeltingManager = ModuleFactory.machineEnabled("fabricator") ? new FabricatorSmeltingRecipeManager() : new DummyManagers.DummyFabricatorSmeltingManager();
        RecipeManagers.fermenterManager = ModuleFactory.machineEnabled("fermenter") ? new FermenterRecipeManager() : new DummyManagers.DummyFermenterManager();
        RecipeManagers.moistenerManager = ModuleFactory.machineEnabled("moistener") ? new MoistenerRecipeManager() : new DummyManagers.DummyMoistenerManager();
        RecipeManagers.squeezerManager = ModuleFactory.machineEnabled("squeezer") ? new SqueezerRecipeManager() : new DummyManagers.DummySqueezerManager();
        RecipeManagers.squeezerContainerManager = ModuleFactory.machineEnabled("squeezer") ? new SqueezerContainerRecipeManager() : new DummyManagers.DummySqueezerContainerManager();
        RecipeManagers.stillManager = ModuleFactory.machineEnabled("still") ? new StillRecipeManager() : new DummyManagers.DummyStillManager();
        ModuleFactory.setupFuelManager();
    }

    @Override
    public void disabledSetupAPI() {
        RecipeManagers.carpenterManager = new DummyManagers.DummyCarpenterManager();
        RecipeManagers.centrifugeManager = new DummyManagers.DummyCentrifugeManager();
        RecipeManagers.fabricatorManager = new DummyManagers.DummyFabricatorManager();
        RecipeManagers.fabricatorSmeltingManager = new DummyManagers.DummyFabricatorSmeltingManager();
        RecipeManagers.fermenterManager = new DummyManagers.DummyFermenterManager();
        RecipeManagers.moistenerManager = new DummyManagers.DummyMoistenerManager();
        RecipeManagers.squeezerManager = new DummyManagers.DummySqueezerManager();
        RecipeManagers.stillManager = new DummyManagers.DummyStillManager();
        ModuleFactory.setupFuelManager();
    }

    private static void setupFuelManager() {
        FuelManager.fermenterFuel = ModuleFactory.machineEnabled("fermenter") ? new ItemStackMap() : new DummyMap();
        FuelManager.moistenerResource = ModuleFactory.machineEnabled("moistener") ? new ItemStackMap() : new DummyMap();
        FuelManager.rainSubstrate = ModuleFactory.machineEnabled("rainmaker") ? new ItemStackMap() : new DummyMap();
        FuelManager.bronzeEngineFuel = new FluidMap<EngineBronzeFuel>();
        FuelManager.copperEngineFuel = new ItemStackMap<EngineCopperFuel>();
        FuelManager.generatorFuel = new FluidMap<GeneratorFuel>();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerGuiFactories() {
        ScreenManager.func_216911_a(FactoryContainers.BOTTLER.containerType(), GuiBottler::new);
        ScreenManager.func_216911_a(FactoryContainers.CARPENTER.containerType(), GuiCarpenter::new);
        ScreenManager.func_216911_a(FactoryContainers.CENTRIFUGE.containerType(), GuiCentrifuge::new);
        ScreenManager.func_216911_a(FactoryContainers.FABRICATOR.containerType(), GuiFabricator::new);
        ScreenManager.func_216911_a(FactoryContainers.FERMENTER.containerType(), GuiFermenter::new);
        ScreenManager.func_216911_a(FactoryContainers.MOISTENER.containerType(), GuiMoistener::new);
        ScreenManager.func_216911_a(FactoryContainers.RAINTANK.containerType(), GuiRaintank::new);
        ScreenManager.func_216911_a(FactoryContainers.SQUEEZER.containerType(), GuiSqueezer::new);
        ScreenManager.func_216911_a(FactoryContainers.STILL.containerType(), GuiStill::new);
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryFactory();
    }

    @Override
    public void preInit() {
        ItemStack fertilizerCompound = CoreItems.FERTILIZER_COMPOUND.stack();
        FuelManager.fermenterFuel.put(fertilizerCompound, new FermenterFuel(fertilizerCompound, 56, 200));
        int cyclesCompost = 250;
        int valueCompost = 48;
        ItemStack fertilizerBio = CoreItems.COMPOST.stack();
        ItemStack mulch = CoreItems.MULCH.stack();
        FuelManager.fermenterFuel.put(fertilizerBio, new FermenterFuel(fertilizerBio, valueCompost, cyclesCompost));
        FuelManager.fermenterFuel.put(mulch, new FermenterFuel(mulch, valueCompost, cyclesCompost));
        ItemStack wheat = new ItemStack((IItemProvider)Items.field_151015_O);
        ItemStack mouldyWheat = CoreItems.MOULDY_WHEAT.stack();
        ItemStack decayingWheat = CoreItems.DECAYING_WHEAT.stack();
        FuelManager.moistenerResource.put(wheat, new MoistenerFuel(wheat, mouldyWheat, 0, 300));
        FuelManager.moistenerResource.put(mouldyWheat, new MoistenerFuel(mouldyWheat, decayingWheat, 1, 600));
        FuelManager.moistenerResource.put(decayingWheat, new MoistenerFuel(decayingWheat, mulch, 2, 900));
        ItemStack peat = CoreItems.PEAT.stack();
        FuelManager.copperEngineFuel.put(peat, new EngineCopperFuel(peat, 20, 2500));
        ItemStack bituminousPeat = CoreItems.BITUMINOUS_PEAT.stack();
        FuelManager.copperEngineFuel.put(bituminousPeat, new EngineCopperFuel(bituminousPeat, 40, 3000));
        Fluid biomass = ForestryFluids.BIOMASS.getFluid();
        FuelManager.bronzeEngineFuel.put(biomass, new EngineBronzeFuel(biomass, 50, 2500, 1));
        FuelManager.bronzeEngineFuel.put((Fluid)Fluids.field_204546_a, new EngineBronzeFuel((Fluid)Fluids.field_204546_a, 10, 1000, 3));
        Fluid milk = ForestryFluids.MILK.getFluid();
        FuelManager.bronzeEngineFuel.put(milk, new EngineBronzeFuel(milk, 10, 10000, 3));
        Fluid seedOil = ForestryFluids.SEED_OIL.getFluid();
        FuelManager.bronzeEngineFuel.put(seedOil, new EngineBronzeFuel(seedOil, 30, 2500, 1));
        Fluid honey = ForestryFluids.HONEY.getFluid();
        FuelManager.bronzeEngineFuel.put(honey, new EngineBronzeFuel(honey, 20, 2500, 1));
        Fluid juice = ForestryFluids.JUICE.getFluid();
        FuelManager.bronzeEngineFuel.put(juice, new EngineBronzeFuel(juice, 10, 2500, 1));
        ItemStack iodineCharge = CoreItems.IODINE_CHARGE.stack();
        ItemStack dissipationCharge = CoreItems.CRAFTING_MATERIALS.stack(EnumCraftingMaterial.DISSIPATION_CHARGE, 1);
        FuelManager.rainSubstrate.put(iodineCharge, new RainSubstrate(iodineCharge, 10000, 0.01f));
        FuelManager.rainSubstrate.put(dissipationCharge, new RainSubstrate(dissipationCharge, 0.075f));
        CircuitLayout layoutMachineUpgrade = new CircuitLayout("machine.upgrade", CircuitSocketType.MACHINE);
        ChipsetManager.circuitRegistry.registerLayout(layoutMachineUpgrade);
    }

    @Override
    public void registerObjects() {
        Circuits.machineSpeedUpgrade1 = new CircuitSpeedUpgrade("machine.speed.boost.1", 0.125, 0.05f);
        Circuits.machineSpeedUpgrade2 = new CircuitSpeedUpgrade("machine.speed.boost.2", 0.25, 0.1f);
        Circuits.machineEfficiencyUpgrade1 = new CircuitSpeedUpgrade("machine.efficiency.1", 0.0, -0.1f);
        ICircuitLayout layout = ChipsetManager.circuitRegistry.getLayout("forestry.machine.upgrade");
        if (layout != null) {
            ChipsetManager.solderManager.addRecipe(layout, CoreItems.ELECTRON_TUBES.stack(EnumElectronTube.EMERALD, 1), Circuits.machineSpeedUpgrade1);
            ChipsetManager.solderManager.addRecipe(layout, CoreItems.ELECTRON_TUBES.stack(EnumElectronTube.BLAZE, 1), Circuits.machineSpeedUpgrade2);
            ChipsetManager.solderManager.addRecipe(layout, CoreItems.ELECTRON_TUBES.stack(EnumElectronTube.GOLD, 1), Circuits.machineEfficiencyUpgrade1);
        }
    }

    @Override
    public void registerRecipes() {
        ICircuitLayout layout;
        String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
        FluidStack liquidGlassBucket = ForestryFluids.GLASS.getFluid(1000);
        FluidStack liquidGlassX4 = ForestryFluids.GLASS.getFluid(4000);
        if (ModuleHelper.isEnabled("apiculture") && !liquidGlassBucket.isEmpty() && !liquidGlassX4.isEmpty()) {
            for (int i = 0; i < 16; ++i) {
            }
        }
        if ((layout = ChipsetManager.circuitRegistry.getLayout("forestry.machine.upgrade")) != null) {
            ChipsetManager.solderManager.addRecipe(layout, CoreItems.ELECTRON_TUBES.stack(EnumElectronTube.EMERALD, 1), Circuits.machineSpeedUpgrade1);
            ChipsetManager.solderManager.addRecipe(layout, CoreItems.ELECTRON_TUBES.stack(EnumElectronTube.BLAZE, 1), Circuits.machineSpeedUpgrade2);
            ChipsetManager.solderManager.addRecipe(layout, CoreItems.ELECTRON_TUBES.stack(EnumElectronTube.GOLD, 1), Circuits.machineEfficiencyUpgrade1);
        }
    }

    public static void loadMachineConfig(LocalizedConfiguration config) {
        List<String> enabled = Arrays.asList(config.getStringListLocalized("machines", "enabled", MachineUIDs.ALL.toArray(new String[0]), MachineUIDs.ALL.toArray(new String[0])));
        for (String machineID : MachineUIDs.ALL) {
            MACHINE_ENABLED.put(machineID, enabled.contains(machineID));
        }
    }

    public static boolean machineEnabled(String machineName) {
        return true;
    }
}

