/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.ICraftingProvider;
import forestry.api.recipes.IForestryRecipe;
import forestry.factory.recipes.ClientCraftingHelper;
import forestry.factory.recipes.ServerCraftingHelper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraftforge.fml.DistExecutor;

public class AbstractCraftingProvider<T extends IForestryRecipe>
implements ICraftingProvider<T> {
    private final IRecipeType<T> type;
    private final Set<T> globalRecipes = new HashSet<T>();

    public AbstractCraftingProvider(IRecipeType<T> type) {
        this.type = type;
    }

    @Override
    public boolean addRecipe(T recipe) {
        return this.globalRecipes.add(recipe);
    }

    @Override
    public Collection<T> getRecipes(@Nullable RecipeManager recipeManager) {
        HashSet<T> recipes = new HashSet<T>(this.globalRecipes);
        for (IRecipe recipe : AbstractCraftingProvider.adjust(recipeManager).func_215366_a(this.type).values()) {
            recipes.add((IForestryRecipe)recipe);
        }
        return recipes;
    }

    protected static RecipeManager adjust(@Nullable RecipeManager recipeManager) {
        if (recipeManager == null) {
            return (RecipeManager)DistExecutor.safeRunForDist(() -> ClientCraftingHelper::adjustClient, () -> ServerCraftingHelper::adjustServer);
        }
        return recipeManager;
    }
}

