/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.IFabricatorManager;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.AbstractCraftingProvider;
import forestry.factory.recipes.FakeCraftingInventory;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorRecipeManager
extends AbstractCraftingProvider<IFabricatorRecipe>
implements IFabricatorManager {
    public FabricatorRecipeManager() {
        super(IFabricatorRecipe.TYPE);
    }

    @Override
    public void addRecipe(ItemStack plan, FluidStack molten, ItemStack result, Object[] pattern) {
    }

    @Override
    public Optional<IFabricatorRecipe> findMatchingRecipe(@Nullable RecipeManager recipeManager, World world, FluidStack fluidStack, ItemStack plan, IInventory resources) {
        for (IFabricatorRecipe recipe : this.getRecipes(recipeManager)) {
            if (!fluidStack.containsFluid(recipe.getLiquid()) || !recipe.getPlan().test(plan) || !recipe.getCraftingGridRecipe().func_77569_a(FakeCraftingInventory.of(resources), world)) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    @Override
    public boolean isPlan(@Nullable RecipeManager recipeManager, ItemStack plan) {
        for (IFabricatorRecipe recipe : this.getRecipes(recipeManager)) {
            if (!recipe.getPlan().test(plan)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<IFabricatorRecipe> getRecipesWithOutput(@Nullable RecipeManager recipeManager, ItemStack output) {
        if (output.func_190926_b()) {
            return Collections.emptyList();
        }
        return this.getRecipes(recipeManager).stream().filter(recipe -> {
            ItemStack o = recipe.getCraftingGridRecipe().func_77571_b();
            return ItemStackUtil.isIdenticalItem(output, o);
        }).collect(Collectors.toList());
    }
}

