/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.factory.recipes.RecipeSerializers;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MoistenerRecipe
implements IMoistenerRecipe {
    private final ResourceLocation id;
    private final int timePerItem;
    private final Ingredient resource;
    private final ItemStack product;

    public MoistenerRecipe(ResourceLocation id, Ingredient resource, ItemStack product, int timePerItem) {
        Preconditions.checkNotNull((Object)id, (Object)"Recipe identifier cannot be null");
        Preconditions.checkNotNull((Object)resource, (Object)"Resource cannot be null");
        Preconditions.checkNotNull((Object)product, (Object)"Product cannot be null");
        this.id = id;
        this.timePerItem = timePerItem;
        this.resource = resource;
        this.product = product;
    }

    @Override
    public int getTimePerItem() {
        return this.timePerItem;
    }

    @Override
    public Ingredient getResource() {
        return this.resource;
    }

    @Override
    public ItemStack getProduct() {
        return this.product;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<MoistenerRecipe> {
        public MoistenerRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int timePerItem = JSONUtils.func_151203_m((JsonObject)json, (String)"time");
            Ingredient resource = RecipeSerializers.deserialize(json.get("resource"));
            ItemStack product = RecipeSerializers.item(JSONUtils.func_152754_s((JsonObject)json, (String)"product"));
            return new MoistenerRecipe(recipeId, resource, product, timePerItem);
        }

        public MoistenerRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int timePerItem = buffer.func_150792_a();
            Ingredient resource = Ingredient.func_199566_b((PacketBuffer)buffer);
            ItemStack product = buffer.func_150791_c();
            return new MoistenerRecipe(recipeId, resource, product, timePerItem);
        }

        public void toNetwork(PacketBuffer buffer, MoistenerRecipe recipe) {
            buffer.func_150787_b(recipe.timePerItem);
            recipe.resource.func_199564_a(buffer);
            buffer.func_150788_a(recipe.product);
        }
    }
}

