/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.centrifuge;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryRecipeCategoryUid;
import forestry.core.recipes.jei.ForestryTooltipCallback;
import forestry.factory.blocks.BlockTypeFactoryTesr;
import forestry.factory.features.FactoryBlocks;
import forestry.factory.recipes.jei.centrifuge.CentrifugeRecipeWrapper;
import forestry.modules.features.FeatureBlock;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CentrifugeRecipeCategory
extends ForestryRecipeCategory<CentrifugeRecipeWrapper> {
    private static final int[][] OUTPUTS = new int[][]{{0, 0}, {1, 0}, {2, 0}, {0, 1}, {1, 1}, {2, 1}, {0, 2}, {1, 2}, {2, 2}};
    private static final Comparator<Map.Entry<ItemStack, Float>> highestChanceComparator = (o1, o2) -> ((Float)o2.getValue()).compareTo((Float)o1.getValue());
    private static final int inputSlot = 0;
    private static final int outputSlot = 1;
    private static final ResourceLocation guiTexture = new ResourceLocation("forestry", "textures/gui/centrifugesocket2.png");
    private final IDrawableAnimated arrow;
    private final IDrawable icon;

    public CentrifugeRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(guiTexture, 11, 18, 154, 54), "block.forestry.centrifuge");
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(guiTexture, 176, 0, 4, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 80, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.CENTRIFUGE)).block()));
    }

    private static void setResults(ForestryTooltipCallback tooltip, Map<ItemStack, Float> outputs, IGuiItemStackGroup guiItemStacks) {
        Set<Map.Entry<ItemStack, Float>> entrySet = outputs.entrySet();
        if (entrySet.isEmpty()) {
            return;
        }
        PriorityQueue<Map.Entry<ItemStack, Float>> sortByChance = new PriorityQueue<Map.Entry<ItemStack, Float>>(entrySet.size(), highestChanceComparator);
        sortByChance.addAll(entrySet);
        int i = 0;
        while (!sortByChance.isEmpty()) {
            Map.Entry stack = (Map.Entry)sortByChance.poll();
            if (i >= OUTPUTS.length) {
                return;
            }
            int x = 100 + OUTPUTS[i][0] * 18;
            int y = OUTPUTS[i][1] * 18;
            int slotIndex = 1 + i;
            guiItemStacks.init(slotIndex, false, x, y);
            guiItemStacks.set(slotIndex, (ItemStack)stack.getKey());
            tooltip.addChanceTooltip(slotIndex, ((Float)stack.getValue()).floatValue());
            ++i;
        }
    }

    public ResourceLocation getUid() {
        return ForestryRecipeCategoryUid.CENTRIFUGE;
    }

    public Class<? extends CentrifugeRecipeWrapper> getRecipeClass() {
        return CentrifugeRecipeWrapper.class;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayout recipeLayout, CentrifugeRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 4, 18);
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        guiItemStacks.set(0, (List)inputs.get(0));
        ForestryTooltipCallback tooltip = new ForestryTooltipCallback();
        LinkedHashMap<ItemStack, Float> products = new LinkedHashMap<ItemStack, Float>();
        for (ICentrifugeRecipe.Product product : ((ICentrifugeRecipe)recipeWrapper.getRecipe()).getAllProducts()) {
            products.put(product.getStack(), Float.valueOf(product.getProbability()));
        }
        CentrifugeRecipeCategory.setResults(tooltip, products, guiItemStacks);
        guiItemStacks.addTooltipCallback((ITooltipCallback)tooltip);
    }

    public void draw(CentrifugeRecipeWrapper recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 32, 18);
        this.arrow.draw(matrixStack, 56, 18);
    }
}

