/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.blocks;

import com.google.common.collect.ImmutableList;
import forestry.api.core.IBlockSubtype;
import forestry.core.utils.ResourceUtil;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;

public enum EnumFarmBlockType implements IBlockSubtype
{
    PLAIN,
    GEARBOX,
    HATCH,
    VALVE,
    CONTROL;

    public static final EnumFarmBlockType[] VALUES;
    private static final int TYPE_PLAIN = 0;
    private static final int TYPE_REVERSE = 1;
    private static final int TYPE_TOP = 2;
    private static final int TYPE_BAND = 3;
    private static final int TYPE_GEARS = 4;
    private static final int TYPE_HATCH = 5;
    private static final int TYPE_VALVE = 6;
    private static final int TYPE_CONTROL = 7;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    private static ImmutableList<TextureAtlasSprite> sprites;

    @OnlyIn(value=Dist.CLIENT)
    public static void gatherSprites(TextureStitchEvent.Pre event) {
        event.addSprite(new ResourceLocation("forestry", "block/farm/plain"));
        event.addSprite(new ResourceLocation("forestry", "block/farm/reverse"));
        event.addSprite(new ResourceLocation("forestry", "block/farm/top"));
        event.addSprite(new ResourceLocation("forestry", "block/farm/band"));
        event.addSprite(new ResourceLocation("forestry", "block/farm/gears"));
        event.addSprite(new ResourceLocation("forestry", "block/farm/hatch"));
        event.addSprite(new ResourceLocation("forestry", "block/farm/valve"));
        event.addSprite(new ResourceLocation("forestry", "block/farm/control"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void fillSprites(TextureStitchEvent.Post event) {
        AtlasTexture map = event.getMap();
        sprites = ImmutableList.of((Object)map.func_195424_a(new ResourceLocation("forestry", "block/farm/plain")), (Object)map.func_195424_a(new ResourceLocation("forestry", "block/farm/reverse")), (Object)map.func_195424_a(new ResourceLocation("forestry", "block/farm/top")), (Object)map.func_195424_a(new ResourceLocation("forestry", "block/farm/band")), (Object)map.func_195424_a(new ResourceLocation("forestry", "block/farm/gears")), (Object)map.func_195424_a(new ResourceLocation("forestry", "block/farm/hatch")), (Object)map.func_195424_a(new ResourceLocation("forestry", "block/farm/valve")), (Object)map.func_195424_a(new ResourceLocation("forestry", "block/farm/control")));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TextureAtlasSprite getSprite(EnumFarmBlockType type, int side) {
        if (sprites == null) {
            return ResourceUtil.getMissingTexture();
        }
        switch (type) {
            case PLAIN: {
                if (side == 2) {
                    return (TextureAtlasSprite)sprites.get(1);
                }
                if (side == 0 || side == 1) {
                    return (TextureAtlasSprite)sprites.get(2);
                }
                return (TextureAtlasSprite)sprites.get(0);
            }
            case GEARBOX: {
                return (TextureAtlasSprite)sprites.get(4);
            }
            case HATCH: {
                return (TextureAtlasSprite)sprites.get(5);
            }
            case VALVE: {
                return (TextureAtlasSprite)sprites.get(6);
            }
            case CONTROL: {
                return (TextureAtlasSprite)sprites.get(7);
            }
        }
        return (TextureAtlasSprite)sprites.get(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite[] getSprites() {
        TextureAtlasSprite[] textures = new TextureAtlasSprite[6];
        for (int side = 0; side < textures.length; ++side) {
            textures[side] = EnumFarmBlockType.getSprite(this, side);
        }
        return textures;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TextureAtlasSprite[] getBandSprites() {
        TextureAtlasSprite band = sprites == null ? ResourceUtil.getMissingTexture() : (TextureAtlasSprite)sprites.get(3);
        Object[] textures = new TextureAtlasSprite[6];
        Arrays.fill(textures, band);
        return textures;
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    static {
        VALUES = EnumFarmBlockType.values();
    }
}

