/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.circuits;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmCircuit;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmProperties;
import forestry.core.circuits.Circuit;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;

public class CircuitFarmLogic
extends Circuit
implements IFarmCircuit {
    private final IFarmProperties properties;
    private final IFarmLogic logic;

    public CircuitFarmLogic(String uid, IFarmProperties instance, boolean manual) {
        super(uid);
        this.logic = instance.getLogic(manual);
        this.properties = instance;
    }

    public CircuitFarmLogic(String uid, IFarmLogic logic) {
        super(uid);
        this.logic = logic;
        this.properties = logic.getProperties();
    }

    @Override
    public String getTranslationKey() {
        return this.properties.getTranslationKey();
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.properties.getDisplayName(this.logic.isManual());
    }

    @Override
    public IFarmLogic getFarmLogic() {
        return this.logic;
    }

    @Override
    public boolean isCircuitable(Object tile) {
        return tile instanceof IFarmHousing;
    }

    @Nullable
    private IFarmHousing getCircuitable(Object tile) {
        if (!this.isCircuitable(tile)) {
            return null;
        }
        return (IFarmHousing)tile;
    }

    @Override
    public void onInsertion(int slot, Object tile) {
        IFarmHousing housing = this.getCircuitable(tile);
        if (housing == null) {
            return;
        }
        housing.setFarmLogic(FarmDirection.values()[slot], this.logic);
    }

    @Override
    public void onLoad(int slot, Object tile) {
        this.onInsertion(slot, tile);
    }

    @Override
    public void onRemoval(int slot, Object tile) {
        IFarmHousing farmHousing = this.getCircuitable(tile);
        if (farmHousing == null) {
            return;
        }
        farmHousing.resetFarmLogic(FarmDirection.values()[slot]);
    }

    @Override
    public void onTick(int slot, Object tile) {
    }
}

