/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmPropertiesBuilder;
import forestry.api.farming.IFarmable;
import forestry.api.farming.IFarmableInfo;
import forestry.api.farming.Soil;
import forestry.farming.FarmRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.text.WordUtils;

public final class FarmProperties
implements IFarmProperties {
    private final Set<Soil> soils;
    private final IFarmLogic manualLogic;
    private final IFarmLogic managedLogic;
    private final Supplier<ItemStack> icon;
    private final Collection<IFarmable> farmables;
    private final Collection<IFarmableInfo> farmableInfo;
    private final ToIntFunction<IFarmHousing> fertilizerConsumption;
    private final ToIntBiFunction<IFarmHousing, Float> waterConsumption;
    private final String translationKey;

    public FarmProperties(Builder builder) {
        Preconditions.checkNotNull((Object)builder.factory);
        Preconditions.checkNotNull((Object)builder.icon);
        Preconditions.checkNotNull((Object)builder.waterConsumption);
        Preconditions.checkNotNull((Object)builder.fertilizerConsumption);
        Preconditions.checkNotNull((Object)builder.translationKey);
        FarmRegistry registry = FarmRegistry.getInstance();
        this.manualLogic = (IFarmLogic)builder.factory.apply(this, true);
        this.managedLogic = (IFarmLogic)builder.factory.apply(this, false);
        this.soils = ImmutableSet.copyOf((Collection)builder.soils);
        ImmutableSet.Builder farmableBuilder = new ImmutableSet.Builder();
        ImmutableSet.Builder infoBuilder = new ImmutableSet.Builder();
        for (String farmableIdentifier : builder.farmablesIdentifiers) {
            farmableBuilder.addAll(registry.getFarmables(farmableIdentifier));
            infoBuilder.add((Object)registry.getFarmableInfo(farmableIdentifier));
        }
        this.farmables = farmableBuilder.build();
        this.farmableInfo = infoBuilder.build();
        this.fertilizerConsumption = builder.fertilizerConsumption;
        this.waterConsumption = builder.waterConsumption;
        this.translationKey = builder.translationKey;
        this.icon = builder.icon;
    }

    @Override
    public Collection<IFarmable> getFarmables() {
        return this.farmables;
    }

    @Override
    public Collection<IFarmableInfo> getFarmableInfo() {
        return this.farmableInfo;
    }

    @Override
    public IFarmLogic getLogic(boolean manuel) {
        return manuel ? this.manualLogic : this.managedLogic;
    }

    @Override
    public boolean isAcceptedSoil(BlockState ground) {
        for (Soil soil : this.soils) {
            BlockState soilState = soil.getSoilState();
            if (soilState.func_177230_c() != ground.func_177230_c()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        for (Soil soil : this.soils) {
            if (!soil.getResource().func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getFertilizerConsumption(IFarmHousing housing) {
        return this.fertilizerConsumption.applyAsInt(housing);
    }

    @Override
    public int getWaterConsumption(IFarmHousing housing, float hydrationModifier) {
        return this.waterConsumption.applyAsInt(housing, Float.valueOf(hydrationModifier));
    }

    @Override
    public ITextComponent getDisplayName(boolean manual) {
        String unformatted = manual ? "for.farm.grammar.manual" : "for.farm.grammar.managed";
        return new TranslationTextComponent(unformatted, new Object[]{new TranslationTextComponent(this.translationKey)});
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    public ItemStack getIcon() {
        return this.icon.get();
    }

    @Override
    public boolean isAcceptedSeedling(ItemStack itemstack) {
        for (IFarmable farmable : this.farmables) {
            if (!farmable.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack itemstack) {
        for (IFarmable farmable : this.farmables) {
            if (!farmable.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Soil> getSoils() {
        return this.soils;
    }

    public static class Builder
    implements IFarmPropertiesBuilder {
        private final String identifier;
        private final Set<Soil> soils = new HashSet<Soil>();
        private final Set<String> farmablesIdentifiers = new HashSet<String>();
        private final IFarmableInfo defaultInfo;
        @Nullable
        private BiFunction<IFarmProperties, Boolean, IFarmLogic> factory;
        @Nullable
        private Supplier<ItemStack> icon;
        @Nullable
        private ToIntFunction<IFarmHousing> fertilizerConsumption;
        @Nullable
        private ToIntBiFunction<IFarmHousing, Float> waterConsumption;
        @Nullable
        private String translationKey;

        public Builder(String identifier) {
            this.identifier = identifier;
            this.defaultInfo = FarmRegistry.getInstance().getFarmableInfo(identifier);
        }

        @Override
        public IFarmPropertiesBuilder addFarmables(String ... identifiers) {
            this.farmablesIdentifiers.addAll(Arrays.asList(identifiers));
            return this;
        }

        @Override
        public IFarmPropertiesBuilder setFactory(BiFunction<IFarmProperties, Boolean, IFarmLogic> factory) {
            this.factory = factory;
            return this;
        }

        @Override
        public IFarmPropertiesBuilder setIcon(Supplier<ItemStack> stackSupplier) {
            this.icon = stackSupplier;
            return this;
        }

        @Override
        public IFarmPropertiesBuilder setFertilizer(ToIntFunction<IFarmHousing> consumption) {
            this.fertilizerConsumption = consumption;
            return this;
        }

        @Override
        public IFarmPropertiesBuilder setWater(ToIntBiFunction<IFarmHousing, Float> waterConsumption) {
            this.waterConsumption = waterConsumption;
            return this;
        }

        @Override
        public IFarmPropertiesBuilder setTranslationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        @Override
        public IFarmPropertiesBuilder addSoil(ItemStack resource, BlockState soilState) {
            this.soils.add(new Soil(resource, soilState));
            return this;
        }

        @Override
        public IFarmPropertiesBuilder addSeedlings(ItemStack ... seedling) {
            this.defaultInfo.addSeedlings(seedling);
            return this;
        }

        @Override
        public IFarmPropertiesBuilder addSeedlings(Collection<ItemStack> seedling) {
            this.defaultInfo.addSeedlings(seedling);
            return this;
        }

        @Override
        public IFarmPropertiesBuilder addProducts(ItemStack ... products) {
            this.defaultInfo.addProducts(products);
            return this;
        }

        @Override
        public IFarmPropertiesBuilder addProducts(Collection<ItemStack> products) {
            this.defaultInfo.addProducts(products);
            return this;
        }

        @Override
        public IFarmProperties create() {
            return FarmRegistry.getInstance().registerProperties("farm" + WordUtils.capitalize((String)this.identifier), new FarmProperties(this));
        }
    }
}

