/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.api.farming.IFarmableInfo;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.NetworkUtil;
import forestry.farming.logic.crops.CropDestroy;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableRusticSapling
implements IFarmable {
    protected final Item germling;
    protected final Block germlingBlock;
    private final ItemStack[] windfall;

    public FarmableRusticSapling(Item germling, ItemStack[] windfall) {
        this.germling = germling;
        this.germlingBlock = Block.func_149634_a((Item)germling);
        this.windfall = windfall;
    }

    @Override
    public boolean plantSaplingAt(PlayerEntity player, ItemStack germling, World world, BlockPos pos) {
        BlockState blockState = this.germlingBlock.func_176223_P();
        if (world.func_175656_a(pos, blockState)) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.SoundFXType.BLOCK_PLACE, pos, blockState);
            NetworkUtil.sendNetworkPacket(packet, pos, world);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos, BlockState blockState) {
        return blockState.func_177230_c() == this.germlingBlock;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos, BlockState blockState) {
        Block block = blockState.func_177230_c();
        return new CropDestroy(world, blockState, pos, null);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return this.germling == itemstack.func_77973_b();
    }

    @Override
    public void addInformation(IFarmableInfo info) {
        info.addSeedlings(new ItemStack((IItemProvider)this.germling));
        info.addProducts(this.windfall);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        for (ItemStack drop : this.windfall) {
            if (!drop.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }
}

