/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.ForestryComponentKeys;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.EnumFlutterType;
import forestry.api.lepidopterology.genetics.IAlleleButterflySpecies;
import forestry.core.genetics.root.IResearchPlugin;
import forestry.core.genetics.root.ResearchHandler;
import forestry.lepidopterology.features.LepidopterologyItems;
import forestry.lepidopterology.genetics.ButterflyBranchDefinition;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import forestry.lepidopterology.genetics.ButterflyHelper;
import forestry.lepidopterology.genetics.ButterflyRoot;
import forestry.lepidopterology.genetics.MothDefinition;
import forestry.lepidopterology.genetics.alleles.ButterflyAlleles;
import genetics.api.GeneticPlugin;
import genetics.api.GeneticsAPI;
import genetics.api.IGeneticApiInstance;
import genetics.api.IGeneticFactory;
import genetics.api.IGeneticPlugin;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.classification.IClassificationRegistry;
import genetics.api.individual.IIndividual;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IGeneticListenerRegistry;
import genetics.api.root.IIndividualRootBuilder;
import genetics.api.root.IRootDefinition;
import genetics.api.root.IRootManager;
import genetics.api.root.components.ComponentKeys;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

@GeneticPlugin(modId="forestry")
public class ButterflyPlugin
implements IGeneticPlugin {
    public static final IRootDefinition<ButterflyRoot> ROOT = GeneticsAPI.apiInstance.getRoot("rootButterflies");

    @Override
    public void registerClassifications(IClassificationRegistry registry) {
        ButterflyBranchDefinition.createClassifications(registry);
    }

    @Override
    public void registerListeners(IGeneticListenerRegistry registry) {
        registry.add("rootButterflies", ButterflyDefinition.values());
        registry.add("rootButterflies", MothDefinition.values());
    }

    @Override
    public void registerAlleles(IAlleleRegistry registry) {
        ButterflyAlleles.registerAlleles(registry);
    }

    @Override
    public void createRoot(IRootManager rootManager, IGeneticFactory geneticFactory) {
        IIndividualRootBuilder rootBuilder = rootManager.createRoot("rootButterflies");
        rootBuilder.setRootFactory(ButterflyRoot::new).setSpeciesType(ButterflyChromosomes.SPECIES).addListener(ComponentKeys.TYPES, builder -> {
            builder.registerType((IOrganismType)EnumFlutterType.SERUM, LepidopterologyItems.SERUM_GE::stack);
            builder.registerType((IOrganismType)EnumFlutterType.CATERPILLAR, LepidopterologyItems.CATERPILLAR_GE::stack);
            builder.registerType((IOrganismType)EnumFlutterType.COCOON, LepidopterologyItems.COCOON_GE::stack);
            builder.registerType((IOrganismType)EnumFlutterType.BUTTERFLY, LepidopterologyItems.BUTTERFLY_GE::stack);
        }).addComponent(ComponentKeys.TRANSLATORS).addComponent(ComponentKeys.MUTATIONS).addComponent(ForestryComponentKeys.RESEARCH, ResearchHandler::new).addListener(ForestryComponentKeys.RESEARCH, component -> component.addPlugin(new IResearchPlugin(){

            @Override
            public float getResearchSuitability(IAlleleSpecies species, ItemStack itemstack) {
                if (itemstack.func_190926_b() || !(species instanceof IAlleleButterflySpecies)) {
                    return -1.0f;
                }
                IAlleleButterflySpecies butterflySpecies = (IAlleleButterflySpecies)species;
                if (itemstack.func_77973_b() == Items.field_151069_bo) {
                    return 0.9f;
                }
                for (ItemStack stack : butterflySpecies.getButterflyLoot().getPossibleStacks()) {
                    if (!stack.func_77969_a(itemstack)) continue;
                    return 1.0f;
                }
                for (ItemStack stack : butterflySpecies.getCaterpillarLoot().getPossibleStacks()) {
                    if (!stack.func_77969_a(itemstack)) continue;
                    return 1.0f;
                }
                return -1.0f;
            }

            @Override
            public NonNullList<ItemStack> getResearchBounty(IAlleleSpecies species, World world, GameProfile researcher, IIndividual individual, int bountyLevel) {
                ItemStack serum = species.getRoot().getTypes().createStack(individual.copy(), EnumFlutterType.SERUM);
                NonNullList bounty = NonNullList.func_191196_a();
                bounty.add((Object)serum);
                return bounty;
            }
        })).setDefaultTemplate(ButterflyHelper::createDefaultTemplate);
    }

    @Override
    public void onFinishRegistration(IRootManager manager, IGeneticApiInstance instance) {
        ButterflyManager.butterflyRoot = ButterflyManager.butterflyRootDefinition.get();
    }
}

