/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.blocks;

import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.genetics.EnumFlutterType;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.core.tiles.TileUtil;
import forestry.lepidopterology.blocks.MaterialCocoon;
import forestry.lepidopterology.blocks.PropertyCocoon;
import forestry.lepidopterology.genetics.alleles.AlleleButterflyCocoon;
import forestry.lepidopterology.genetics.alleles.ButterflyAlleles;
import forestry.lepidopterology.tiles.TileCocoon;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;

public class BlockCocoon
extends Block {
    public static final VoxelShape BOUNDING_BOX = Block.func_208617_a((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
    private static final PropertyCocoon COCOON = AlleleButterflyCocoon.COCOON;

    public BlockCocoon() {
        super(AbstractBlock.Properties.func_200945_a((Material)MaterialCocoon.INSTANCE).func_200944_c().func_200947_a(SoundType.field_185849_b));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)COCOON, (Comparable)ButterflyAlleles.cocoonDefault)).func_206870_a((Property)AlleleButterflyCocoon.AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{COCOON, AlleleButterflyCocoon.AGE});
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        TileCocoon tileCocoon = TileUtil.getTile((IBlockReader)world, pos, TileCocoon.class);
        if (tileCocoon == null) {
            return;
        }
        if (tileCocoon.func_145837_r()) {
            return;
        }
        tileCocoon.onBlockTick();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileCocoon(false);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing != Direction.UP || !facingState.isAir((IBlockReader)worldIn, facingPos)) {
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileCocoon tile = TileUtil.getTile(world, pos, TileCocoon.class);
        if (tile == null) {
            return ItemStack.field_190927_a;
        }
        IButterfly caterpillar = tile.getCaterpillar();
        int age = tile.getAge();
        ItemStack stack = ButterflyManager.butterflyRoot.getTypes().createStack(caterpillar, EnumFlutterType.COCOON);
        if (!stack.func_190926_b() && stack.func_77978_p() != null) {
            stack.func_77978_p().func_74768_a("Age", age);
        }
        return stack;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BOUNDING_BOX;
    }
}

