/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.blocks;

import forestry.apiculture.items.ItemScoop;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.lepidopterology.blocks.BlockCocoon;
import forestry.lepidopterology.blocks.MaterialCocoon;
import forestry.lepidopterology.blocks.PropertyCocoon;
import forestry.lepidopterology.genetics.alleles.AlleleButterflyCocoon;
import forestry.lepidopterology.genetics.alleles.ButterflyAlleles;
import forestry.lepidopterology.tiles.TileCocoon;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockSolidCocoon
extends Block {
    private static final PropertyCocoon COCOON = AlleleButterflyCocoon.COCOON;

    public BlockSolidCocoon() {
        super(AbstractBlock.Properties.func_200945_a((Material)MaterialCocoon.INSTANCE).harvestTool(ItemScoop.SCOOP).harvestLevel(0).func_200943_b(0.5f).func_200944_c().func_200947_a(SoundType.field_185849_b));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)COCOON, (Comparable)ButterflyAlleles.cocoonDefault)).func_206870_a((Property)AlleleButterflyCocoon.AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{COCOON, AlleleButterflyCocoon.AGE});
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (this.canHarvestBlock(state, (IBlockReader)world, pos, player)) {
            TileUtil.actOnTile((IWorldReader)world, pos, TileCocoon.class, cocoon -> {
                NonNullList<ItemStack> drops = cocoon.getCocoonDrops();
                for (ItemStack stack : drops) {
                    ItemStackUtil.dropItemStackAsEntity(stack, world, pos);
                }
            });
        }
        return world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileCocoon(true);
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing != Direction.UP || !facingState.isAir((IBlockReader)worldIn, facingPos)) {
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return BlockCocoon.BOUNDING_BOX;
    }
}

