/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import com.google.common.base.CaseFormat;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.EnumFlutterType;
import forestry.api.lepidopterology.genetics.IAlleleButterflySpecies;
import forestry.api.lepidopterology.genetics.IAlleleButterflySpeciesBuilder;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflyMutationBuilder;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.lepidopterology.genetics.ButterflyBranchDefinition;
import forestry.lepidopterology.genetics.ButterflyHelper;
import forestry.lepidopterology.genetics.IButterflyDefinition;
import forestry.lepidopterology.genetics.MothDefinition;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.alleles.IAlleleTemplateBuilder;
import genetics.api.classification.IClassification;
import genetics.api.individual.IGenome;
import genetics.api.root.ITemplateContainer;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.ComponentKeys;
import genetics.api.root.components.IRootComponent;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public enum ButterflyDefinition implements IButterflyDefinition
{
    CabbageWhite(ButterflyBranchDefinition.PIERIS, "cabbageWhite", "rapae", new Color(0xCCFFEE), true, 1.0f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.AVERAGE);
        }
    }
    ,
    Brimstone(ButterflyBranchDefinition.GONEPTERYX, "brimstone", "rhamni", new Color(15789624), true, 1.0f),
    Aurora(ButterflyBranchDefinition.ANTHOCHARIS, "orangeTip", "cardamines", new Color(14896901), true, 0.5f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.SMALLER);
        }
    }
    ,
    Postillion(ButterflyBranchDefinition.COLIAS, "postillion", "croceus", new Color(14122500), true, 0.5f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SPEED, EnumAllele.Speed.SLOW);
        }
    }
    ,
    PalaenoSulphur(ButterflyBranchDefinition.COLIAS, "palaenoSulphur", "palaeno", new Color(16317347), true, 0.4f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SPEED, EnumAllele.Speed.SLOWER);
        }
    }
    ,
    Reseda(ButterflyBranchDefinition.PONTIA, "reseda", "edusa", new Color(7634248), true, 0.3f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SPEED, EnumAllele.Speed.SLOWER);
        }
    }
    ,
    SpringAzure(ButterflyBranchDefinition.CELASTRINA, "springAzure", "argiolus", new Color(12110562), true, 0.3f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.SMALLER);
            template.set(ButterflyChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORT);
        }
    }
    ,
    GozoraAzure(ButterflyBranchDefinition.CELASTRINA, "gozoraAzure", "gozora", new Color(6844647), true, 0.2f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.SMALLER);
            template.set(ButterflyChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORT);
        }
    }
    ,
    CitrusSwallow(ButterflyBranchDefinition.PAPILIO, "swallowtailC", "demodocus", new Color(15393673), false, 1.0f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            ((IAlleleButterflySpeciesBuilder)species.setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.LARGE);
            template.set(ButterflyChromosomes.FERTILITY, 10);
            template.set(ButterflyChromosomes.METABOLISM, 8);
            template.set(ButterflyChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORTER);
            template.set(ButterflyChromosomes.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
            template.set(ButterflyChromosomes.HUMIDITY_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
        }
    }
    ,
    EmeraldPeacock(ButterflyBranchDefinition.PAPILIO, "emeraldPeacock", "palinurus", new Color(8191616), true, 0.1f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            ((IAlleleButterflySpeciesBuilder)species.setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.LARGE);
            template.set(ButterflyChromosomes.LIFESPAN, EnumAllele.Lifespan.NORMAL);
            template.set(ButterflyChromosomes.FERTILITY, 5);
            template.set(ButterflyChromosomes.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
            template.set(ButterflyChromosomes.HUMIDITY_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
        }
    }
    ,
    ThoasSwallow(ButterflyBranchDefinition.PAPILIO, "swallowtailT", "thoas", new Color(15386499), false, 0.2f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            ((IAlleleButterflySpeciesBuilder)species.setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.LARGE);
            template.set(ButterflyChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORTEST);
        }
    }
    ,
    Spicebush(ButterflyBranchDefinition.PAPILIO, "swallowtailS", "troilus", new Color(0xEEFEFF), true, 0.5f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.AVERAGE);
        }
    }
    ,
    BlackSwallow(ButterflyBranchDefinition.PAPILIO, "swallowtailB", "polyxenes", new Color(15386499), true, 1.0f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SPEED, EnumAllele.Speed.SLOW);
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.LARGE);
            template.set(ButterflyChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORTER);
            template.set(ButterflyChromosomes.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
            template.set(ButterflyChromosomes.HUMIDITY_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
        }
    }
    ,
    ZebraSwallow(ButterflyBranchDefinition.PROTOGRAPHIUM, "swallowtailZ", "marcellus", new Color(0xEAFEFF), true, 0.5f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.AVERAGE);
        }
    }
    ,
    Glasswing(ButterflyBranchDefinition.GRETA, "glasswing", "oto", new Color(5781298), true, 0.1f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            species.setTemperature(EnumTemperature.WARM);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.SMALLER);
            template.set(ButterflyChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORT);
            template.set(ButterflyChromosomes.FERTILITY, 5);
            template.set(ButterflyChromosomes.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
        }
    }
    ,
    SpeckledWood(ButterflyBranchDefinition.PARARGE, "speckledWood", "aegeria", new Color(9728581), true, 1.0f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.FERTILITY, 2);
        }
    }
    ,
    MSpeckledWood(ButterflyBranchDefinition.PARARGE, "speckledWoodM", "xiphia", new Color(4204825), true, 0.5f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.FERTILITY, 2);
        }
    }
    ,
    CSpeckledWood(ButterflyBranchDefinition.PARARGE, "speckledWoodC", "xiphioides", new Color(5322538), true, 0.5f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.FERTILITY, 2);
        }
    }
    ,
    MBlueMorpho(ButterflyBranchDefinition.MORPHO, "blueMorphoM", "menelaus", new Color(7528957), true, 0.5f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            ((IAlleleButterflySpeciesBuilder)species.setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.LARGER);
            template.set(ButterflyChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORTEST);
            template.set(ButterflyChromosomes.FERTILITY, 2);
        }
    }
    ,
    PBlueMorpho(ButterflyBranchDefinition.MORPHO, "blueMorphoP", "peleides", new Color(7261416), true, 0.25f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            ((IAlleleButterflySpeciesBuilder)species.setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.LARGER);
            template.set(ButterflyChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORTEST);
            template.set(ButterflyChromosomes.FERTILITY, 2);
        }
    }
    ,
    RBlueMorpho(ButterflyBranchDefinition.MORPHO, "blueMorphoR", "rhetenor", new Color(48888), true, 0.1f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            ((IAlleleButterflySpeciesBuilder)species.setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.LARGER);
            template.set(ButterflyChromosomes.LIFESPAN, EnumAllele.Lifespan.SHORTEST);
            template.set(ButterflyChromosomes.FERTILITY, 2);
        }
    }
    ,
    Comma(ButterflyBranchDefinition.POLYGONIA, "comma", "c-album", new Color(16291077), true, 0.3f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SPEED, EnumAllele.Speed.SLOWER);
        }
    }
    ,
    Batesia(ButterflyBranchDefinition.BATESIA, "paintedBeauty", "hypochlora", new Color(16676707), true, 0.3f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            ((IAlleleButterflySpeciesBuilder)species.setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.LARGE);
        }
    }
    ,
    BlueWing(ButterflyBranchDefinition.MYSCELIA, "blueWing", "ethusa", new Color(3838924), true, 0.3f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.AVERAGE);
            template.set(ButterflyChromosomes.METABOLISM, 5);
        }
    }
    ,
    Monarch(ButterflyBranchDefinition.DANAUS, "monarch", "plexippus", new Color(16754466), true, 0.2f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.AVERAGE);
        }
    }
    ,
    BlueDuke(ButterflyBranchDefinition.BASSARONA, "blueDuke", "durga", new Color(3162688), true, 0.5f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            species.setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.BOTH_1);
        }
    }
    ,
    GlassyTiger(ButterflyBranchDefinition.PARANTICA, "glassyTiger", "aglea", new Color(5978421), true, 0.3f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.AVERAGE);
        }
    }
    ,
    Postman(ButterflyBranchDefinition.HELICONIUS, "postman", "melpomene", new Color(16199725), true, 0.3f),
    Malachite(ButterflyBranchDefinition.SIPROETA, "malachite", "stelenes", new Color(12451667), true, 0.5f){

        @Override
        protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
            ((IAlleleButterflySpeciesBuilder)species.setTemperature(EnumTemperature.WARM)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.AVERAGE);
            template.set(ButterflyChromosomes.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
            template.set(ButterflyChromosomes.HUMIDITY_TOLERANCE, EnumAllele.Tolerance.DOWN_1);
        }
    }
    ,
    LLacewing(ButterflyBranchDefinition.CETHOSIA, "leopardLacewing", "cyane", new Color(16484870), true, 0.7f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.TEMPERATURE_TOLERANCE, EnumAllele.Tolerance.UP_1);
            template.set(ButterflyChromosomes.HUMIDITY_TOLERANCE, EnumAllele.Tolerance.UP_1);
        }
    }
    ,
    DianaFrit(ButterflyBranchDefinition.SPEYERIA, "dianaFritillary", "diana", new Color(16755717), true, 0.6f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.SMALLER);
        }
    };

    private final IAlleleButterflySpecies species;
    private final ButterflyBranchDefinition branch;
    @Nullable
    private IAlleleTemplate template;
    @Nullable
    private IGenome genome;

    private ButterflyDefinition(ButterflyBranchDefinition branchDefinition, String speciesName, String binomial, Color serumColor, boolean dominant, float rarity) {
        this.branch = branchDefinition;
        String uid = "lepi_" + CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.name());
        IClassification parent = this.branch.getBranch().getParent();
        String unlocalizedName = "for.butterflies.species." + parent.getUID().substring(parent.getLevel().name().toLowerCase(Locale.ENGLISH).length() + 1) + '.' + speciesName;
        String unlocalizedDescription = "for.description." + uid;
        String texture = "butterflies/" + uid;
        IAlleleButterflySpeciesBuilder speciesBuilder = ((IAlleleButterflySpeciesBuilder)((IAlleleButterflySpeciesBuilder)((IAlleleButterflySpeciesBuilder)((IAlleleButterflySpeciesBuilder)((IAlleleButterflySpeciesBuilder)ButterflyManager.butterflyFactory.createSpecies("forestry", uid, speciesName).setDescriptionKey(unlocalizedDescription)).setTranslationKey(unlocalizedName)).setTexture(texture).setDominant(dominant)).setBranch(branchDefinition.getBranch())).setBinomial(binomial)).setSerumColour(serumColor).setRarity(rarity);
        speciesBuilder.setRarity(rarity);
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
    }

    public static void preInit() {
    }

    public static void initButterflies() {
        for (ButterflyDefinition butterfly : ButterflyDefinition.values()) {
            butterfly.registerMutations();
        }
    }

    @Override
    public <C extends IRootComponent<IButterfly>> void onComponentSetup(C component) {
        ComponentKey key = component.getKey();
        if (key == ComponentKeys.TEMPLATES) {
            ITemplateContainer registry = (ITemplateContainer)component;
            IAlleleTemplateBuilder templateBuilder = this.branch.getTemplateBuilder();
            templateBuilder.set(ButterflyChromosomes.SPECIES, this.species);
            this.setAlleles(templateBuilder);
            this.template = templateBuilder.build();
            this.genome = this.template.toGenome();
            registry.registerTemplate(this.template);
        }
    }

    @Override
    public void registerAlleles(IAlleleRegistry registry) {
        registry.registerAllele(this.species, ButterflyChromosomes.SPECIES);
    }

    protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
    }

    protected void setAlleles(IAlleleTemplateBuilder template) {
    }

    protected void registerMutations() {
    }

    protected final IButterflyMutationBuilder registerMutation(IButterflyDefinition parent1, IButterflyDefinition parent2, int chance) {
        IAlleleButterflySpecies species2;
        IAlleleButterflySpecies species1;
        if (parent1 instanceof ButterflyDefinition) {
            species1 = ((ButterflyDefinition)parent1).species;
        } else if (parent1 instanceof MothDefinition) {
            species1 = parent1.getSpecies();
        } else {
            throw new IllegalArgumentException("Unknown parent type " + parent1);
        }
        if (parent2 instanceof ButterflyDefinition) {
            species2 = ((ButterflyDefinition)parent2).species;
        } else if (parent2 instanceof MothDefinition) {
            species2 = parent2.getSpecies();
        } else {
            throw new IllegalArgumentException("Unknown parent type " + parent2);
        }
        return ButterflyManager.butterflyMutationFactory.createMutation(species1, species2, this.getTemplate().alleles(), chance);
    }

    @Override
    public IButterfly createIndividual() {
        return this.getTemplate().toIndividual(ButterflyHelper.getRoot());
    }

    @Override
    public final IAlleleTemplate getTemplate() {
        return this.template;
    }

    @Override
    public final IGenome getGenome() {
        return this.genome;
    }

    @Override
    public final ItemStack getMemberStack(EnumFlutterType flutterType) {
        IButterfly butterfly = this.createIndividual();
        return ButterflyHelper.getRoot().getTypes().createStack(butterfly, flutterType);
    }

    @Override
    public IAlleleButterflySpecies getSpecies() {
        return this.species;
    }
}

