/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import com.google.common.base.CaseFormat;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.EnumFlutterType;
import forestry.api.lepidopterology.genetics.IAlleleButterflySpecies;
import forestry.api.lepidopterology.genetics.IAlleleButterflySpeciesBuilder;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflyMutationBuilder;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.lepidopterology.genetics.ButterflyBranchDefinition;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import forestry.lepidopterology.genetics.ButterflyHelper;
import forestry.lepidopterology.genetics.IButterflyDefinition;
import forestry.lepidopterology.genetics.alleles.ButterflyAlleles;
import genetics.api.alleles.IAlleleRegistry;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.alleles.IAlleleTemplateBuilder;
import genetics.api.classification.IClassification;
import genetics.api.individual.IGenome;
import genetics.api.root.ITemplateContainer;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.ComponentKeys;
import genetics.api.root.components.IRootComponent;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public enum MothDefinition implements IButterflyDefinition
{
    Brimstone(ButterflyBranchDefinition.OPISTHOGRAPTIS, "brimstone", "luteolata", new Color(16771648), true, 1.0f),
    LatticedHeath(ButterflyBranchDefinition.CHIASMIA, "latticedHeath", "clathrata", new Color(15921342), true, 0.5f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.SMALLEST);
        }
    }
    ,
    Atlas(ButterflyBranchDefinition.ATTACUS, "atlas", "atlas", new Color(14249533), false, 0.1f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.LARGEST);
        }
    }
    ,
    BombyxMori(ButterflyBranchDefinition.BOMBYX, "bombyxMori", "bombyxMori", new Color(0xDADADA), false, 0.0f){

        @Override
        protected void setAlleles(IAlleleTemplateBuilder template) {
            template.set(ButterflyChromosomes.SIZE, EnumAllele.Size.SMALLEST);
            template.set(ButterflyChromosomes.SPEED, EnumAllele.Speed.SLOWER);
            template.set(ButterflyChromosomes.METABOLISM, 4);
            template.set(ButterflyChromosomes.COCOON, ButterflyAlleles.cocoonSilk);
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(LatticedHeath, ButterflyDefinition.Brimstone, 7);
        }
    };

    private final IAlleleButterflySpecies species;
    private final ButterflyBranchDefinition branch;
    @Nullable
    private IAlleleTemplate template;
    @Nullable
    private IGenome genome;

    private MothDefinition(ButterflyBranchDefinition branchDefinition, String speciesName, String binomial, Color serumColor, boolean dominant, float rarity) {
        this.branch = branchDefinition;
        String uid = "moth_" + CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.name());
        IClassification parent = this.branch.getBranch().getParent();
        String unlocalizedName = "for.butterflies.species." + parent.getUID().substring(parent.getLevel().name().toLowerCase(Locale.ENGLISH).length() + 1) + '.' + speciesName;
        String unlocalizedDescription = "for.description." + uid;
        String texture = "butterflies/" + uid;
        IAlleleButterflySpeciesBuilder speciesBuilder = ((IAlleleButterflySpeciesBuilder)((IAlleleButterflySpeciesBuilder)((IAlleleButterflySpeciesBuilder)((IAlleleButterflySpeciesBuilder)((IAlleleButterflySpeciesBuilder)ButterflyManager.butterflyFactory.createSpecies("forestry", uid, speciesName).setDescriptionKey(unlocalizedDescription)).setTranslationKey(unlocalizedName)).setTexture(texture).setDominant(dominant)).setBranch(branchDefinition.getBranch())).setBinomial(binomial)).setSerumColour(serumColor).setRarity(rarity).setNocturnal();
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
    }

    public static void preInit() {
    }

    public static void initMoths() {
        for (MothDefinition butterfly : MothDefinition.values()) {
            butterfly.registerMutations();
        }
    }

    @Override
    public <C extends IRootComponent<IButterfly>> void onComponentSetup(C component) {
        ComponentKey key = component.getKey();
        if (key == ComponentKeys.TEMPLATES) {
            ITemplateContainer registry = (ITemplateContainer)component;
            IAlleleTemplateBuilder templateBuilder = this.branch.getTemplateBuilder();
            templateBuilder.set(ButterflyChromosomes.SPECIES, this.species);
            this.setAlleles(templateBuilder);
            this.template = templateBuilder.build();
            this.genome = this.template.toGenome();
            registry.registerTemplate(this.template);
        }
    }

    @Override
    public void registerAlleles(IAlleleRegistry registry) {
        registry.registerAllele(this.species, ButterflyChromosomes.SPECIES);
    }

    protected void setSpeciesProperties(IAlleleButterflySpeciesBuilder species) {
    }

    protected void setAlleles(IAlleleTemplateBuilder template) {
    }

    protected void registerMutations() {
    }

    protected final IButterflyMutationBuilder registerMutation(IButterflyDefinition parent1, IButterflyDefinition parent2, int chance) {
        IAlleleButterflySpecies species2;
        IAlleleButterflySpecies species1;
        if (parent1 instanceof MothDefinition) {
            species1 = ((MothDefinition)parent1).species;
        } else if (parent1 instanceof ButterflyDefinition) {
            species1 = parent1.getSpecies();
        } else {
            throw new IllegalArgumentException("Unknown parent1: " + parent1);
        }
        if (parent2 instanceof MothDefinition) {
            species2 = ((MothDefinition)parent2).species;
        } else if (parent2 instanceof ButterflyDefinition) {
            species2 = parent2.getSpecies();
        } else {
            throw new IllegalArgumentException("Unknown parent2: " + parent2);
        }
        return ButterflyManager.butterflyMutationFactory.createMutation(species1, species2, this.getTemplate().alleles(), chance);
    }

    @Override
    public IButterfly createIndividual() {
        return this.getTemplate().toIndividual(ButterflyHelper.getRoot());
    }

    @Override
    public final IAlleleTemplate getTemplate() {
        return this.template;
    }

    @Override
    public final IGenome getGenome() {
        return this.genome;
    }

    @Override
    public final ItemStack getMemberStack(EnumFlutterType flutterType) {
        IButterfly butterfly = this.createIndividual();
        return ButterflyHelper.getRoot().getTypes().createStack(butterfly, flutterType);
    }

    @Override
    public IAlleleButterflySpecies getSpecies() {
        return this.species;
    }
}

