/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.worldgen;

import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.genetics.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.core.config.Config;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Log;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.lepidopterology.blocks.BlockSolidCocoon;
import forestry.lepidopterology.features.LepidopterologyBlocks;
import forestry.lepidopterology.tiles.TileCocoon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class CocoonDecorator
extends Feature<NoFeatureConfig> {
    public CocoonDecorator() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public static boolean genCocoon(ISeedReader world, Random rand, BlockPos pos, IButterfly butterfly) {
        if (butterfly.getGenome().getActiveAllele(ButterflyChromosomes.SPECIES).getRarity() * ModuleLepidopterology.getGenerateCocoonsAmount() < rand.nextFloat() * 100.0f) {
            return false;
        }
        Biome biome = world.func_226691_t_(new BlockPos(pos.func_177958_n(), 0, pos.func_177952_p()));
        Set<Biome.Category> speciesCategories = butterfly.getGenome().getActiveAllele(ButterflyChromosomes.SPECIES).getSpawnBiomes();
        boolean biomeTypesGood = false;
        for (Biome.Category category : speciesCategories) {
            if (category != biome.func_201856_r()) continue;
            biomeTypesGood = true;
            break;
        }
        if (!biomeTypesGood) {
            return false;
        }
        for (int tries = 0; tries < 4; ++tries) {
            int z;
            int x = pos.func_177958_n() + rand.nextInt(16);
            if (!CocoonDecorator.tryGenCocoon(world, x, z = pos.func_177952_p() + rand.nextInt(16), butterfly)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryGenCocoon(ISeedReader world, int x, int z, IButterfly butterfly) {
        int y = CocoonDecorator.getYForCocoon(world, x, z);
        if (y < 0) {
            return false;
        }
        if (!CocoonDecorator.isValidLocation(world, new BlockPos(x, y, z))) {
            return false;
        }
        return CocoonDecorator.setCocoon(world, new BlockPos(x, y, z), butterfly);
    }

    private static boolean setCocoon(ISeedReader world, BlockPos pos, IButterfly butterfly) {
        BlockSolidCocoon cocoonBlock = LepidopterologyBlocks.COCOON_SOLID.getBlock();
        boolean placed = world.func_180501_a(pos, cocoonBlock.func_176223_P(), 2);
        if (!placed) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        if (cocoonBlock != state.func_177230_c()) {
            return false;
        }
        TileCocoon cocoon = TileUtil.getTile((IBlockReader)world, pos, TileCocoon.class);
        if (cocoon == null) {
            return false;
        }
        cocoon.setCaterpillar(butterfly);
        cocoonBlock.func_220082_b(state, (World)world.func_201672_e(), pos, cocoonBlock.func_176223_P(), false);
        world.func_201672_e().func_225319_b(pos, state, cocoonBlock.func_176223_P());
        if (Config.logCocoonPlacement) {
            Log.info("Placed {} at {}", cocoonBlock.toString(), pos.toString());
        }
        return true;
    }

    private static int getYForCocoon(ISeedReader world, int x, int z) {
        int y = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(x, 0, z)).func_177956_o() - 1;
        BlockPos pos = new BlockPos(x, y, z);
        BlockState blockState = world.func_180495_p(pos);
        if (blockState.func_185904_a() != Material.field_151584_j) {
            return -1;
        }
        while ((blockState = world.func_180495_p(pos = pos.func_177977_b())).func_185904_a() == Material.field_151584_j) {
        }
        return y;
    }

    public static boolean isValidLocation(ISeedReader world, BlockPos pos) {
        BlockPos posAbove = pos.func_177984_a();
        BlockState blockStateAbove = world.func_180495_p(posAbove);
        Block blockAbove = blockStateAbove.func_177230_c();
        if (blockStateAbove.func_185904_a() != Material.field_151584_j) {
            return false;
        }
        BlockPos posBelow = pos.func_177977_b();
        BlockState blockStateBelow = world.func_180495_p(posBelow);
        return BlockUtil.canReplace(blockStateBelow, (IWorld)world, posBelow);
    }

    public boolean place(ISeedReader seedReader, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        ArrayList butterflys = new ArrayList(ButterflyManager.butterflyRoot.getIndividualTemplates());
        Collections.shuffle(butterflys, rand);
        for (IButterfly butterfly : butterflys) {
            if (!CocoonDecorator.genCocoon(seedReader, rand, pos, butterfly)) continue;
            return true;
        }
        return false;
    }
}

