/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import forestry.core.gui.ContainerTile;
import forestry.core.gui.slots.SlotOutput;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SlotUtil;
import forestry.mail.POBox;
import forestry.mail.POBoxInfo;
import forestry.mail.features.MailContainers;
import forestry.mail.network.packets.PacketPOBoxInfoResponse;
import forestry.mail.tiles.TileMailbox;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockReader;

public class ContainerMailbox
extends ContainerTile<TileMailbox> {
    public static final short SLOT_LETTERS = 0;
    public static final short SLOT_LETTERS_COUNT = 84;
    @Nullable
    private final POBox mailInventory;

    public static ContainerMailbox fromNetwork(int windowId, PlayerInventory inv, PacketBuffer data) {
        TileMailbox tile = TileUtil.getTile((IBlockReader)inv.field_70458_d.field_70170_p, data.func_179259_c(), TileMailbox.class);
        return new ContainerMailbox(windowId, inv, tile);
    }

    public ContainerMailbox(int windowId, PlayerInventory playerInventory, TileMailbox tile) {
        super(windowId, MailContainers.MAILBOX.containerType(), playerInventory, tile, 35, 145);
        IInventory inventory = tile.getOrCreateMailInventory(playerInventory.field_70458_d.field_70170_p, playerInventory.field_70458_d.func_146103_bH());
        this.mailInventory = inventory instanceof POBox ? (POBox)inventory : null;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 12; ++j) {
                this.func_75146_a(new SlotOutput(inventory, j + i * 9, 8 + j * 18, 8 + i * 18));
            }
        }
    }

    @Override
    public ItemStack func_184996_a(int slotId, int dragType_or_button, ClickType clickTypeIn, PlayerEntity player) {
        ItemStack stack = super.func_184996_a(slotId, dragType_or_button, clickTypeIn, player);
        if (SlotUtil.isSlotInRange(slotId, 0, 84) && !player.field_70170_p.field_72995_K && this.mailInventory != null) {
            POBoxInfo info = this.mailInventory.getPOBoxInfo();
            NetworkUtil.sendToPlayer(new PacketPOBoxInfoResponse(info), player);
        }
        return stack;
    }
}

