/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.core.gui.GuiForestry;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import forestry.mail.gui.ContainerTradeName;
import forestry.mail.network.packets.PacketTraderAddressRequest;
import forestry.mail.tiles.TileTrader;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.StringUtils;

public class GuiTradeName
extends GuiForestry<ContainerTradeName> {
    private final TileTrader tile;
    private TextFieldWidget addressNameField;

    public GuiTradeName(ContainerTradeName container, PlayerInventory inv, ITextComponent title) {
        super("textures/gui/tradername.png", container, inv, title);
        this.tile = (TileTrader)container.getTile();
        this.field_146999_f = 176;
        this.field_147000_g = 90;
        this.addressNameField = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_147003_i + 44, this.field_147009_r + 39, 90, 14, null);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.addressNameField = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_147003_i + 44, this.field_147009_r + 39, 90, 14, null);
        this.addressNameField.func_146180_a(((ContainerTradeName)this.container).getAddress().getName());
        this.addressNameField.func_146195_b(true);
    }

    @Override
    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (this.addressNameField.func_230999_j_()) {
            if (scanCode == 257) {
                this.setAddress();
            } else {
                this.addressNameField.func_231046_a_(key, scanCode, modifiers);
            }
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (super.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return false;
        }
        this.addressNameField.func_231044_a_(mouseX, mouseY, mouseButton);
        return true;
    }

    @Override
    protected void func_230450_a_(MatrixStack transform, float partialTicks, int var3, int var2) {
        super.func_230450_a_(transform, partialTicks, var3, var2);
        String prompt = Translator.translateToLocal("for.gui.mail.nametrader");
        this.textLayout.startPage();
        this.textLayout.newLine();
        this.textLayout.drawCenteredLine(transform, prompt, 0, ColourProperties.INSTANCE.get("gui.mail.text"));
        this.textLayout.endPage();
        this.addressNameField.func_230430_a_(transform, var2, var3, partialTicks);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.setAddress();
    }

    private void setAddress() {
        String address = this.addressNameField.func_146179_b();
        if (StringUtils.isNotBlank((CharSequence)address)) {
            PacketTraderAddressRequest packet = new PacketTraderAddressRequest(this.tile, address);
            NetworkUtil.sendToServer(packet);
        }
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.tile);
    }
}

