/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import forestry.api.core.ForestryAPI;
import forestry.api.modules.ForestryModule;
import forestry.api.modules.IForestryModule;
import forestry.api.modules.IModuleContainer;
import forestry.api.modules.IModuleManager;
import forestry.core.IPickupHandler;
import forestry.core.IResupplyHandler;
import forestry.core.ISaveEventHandler;
import forestry.core.config.forge_old.Configuration;
import forestry.core.utils.Log;
import forestry.modules.ClientModuleHandler;
import forestry.modules.CommonModuleHandler;
import forestry.modules.ForestryPluginUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;

public class ModuleManager
implements IModuleManager {
    private static final String CONFIG_CATEGORY = "modules";
    private static ModuleManager ourInstance = new ModuleManager();
    public static final List<IPickupHandler> pickupHandlers = Lists.newArrayList();
    public static final List<ISaveEventHandler> saveEventHandlers = Lists.newArrayList();
    public static final List<IResupplyHandler> resupplyHandlers = Lists.newArrayList();
    private static final HashMap<ResourceLocation, IForestryModule> sortedModules = new LinkedHashMap<ResourceLocation, IForestryModule>();
    private static final Set<IForestryModule> loadedModules = new LinkedHashSet<IForestryModule>();
    private static final Set<IForestryModule> unloadedModules = new LinkedHashSet<IForestryModule>();
    private static final HashMap<String, IModuleContainer> moduleContainers = new HashMap();
    public static final Set<IForestryModule> configDisabledModules = new HashSet<IForestryModule>();
    public static CommonModuleHandler moduleHandler;

    private ModuleManager() {
    }

    public static ModuleManager getInstance() {
        return ourInstance;
    }

    @Override
    public boolean isModuleEnabled(ResourceLocation id) {
        return sortedModules.get(id) != null;
    }

    @Override
    public void registerContainers(IModuleContainer ... containers) {
        for (IModuleContainer container : containers) {
            Preconditions.checkNotNull((Object)container);
            moduleContainers.put(container.getID(), container);
        }
    }

    @Override
    public Collection<IModuleContainer> getContainers() {
        return moduleContainers.values();
    }

    public static Set<IForestryModule> getLoadedModules() {
        return ImmutableSet.copyOf(sortedModules.values());
    }

    @Nullable
    private static IForestryModule getModuleCore(List<IForestryModule> forestryModules) {
        for (IForestryModule module : forestryModules) {
            ForestryModule info = module.getClass().getAnnotation(ForestryModule.class);
            if (!module.isAvailable() || !info.coreModule()) continue;
            return module;
        }
        return null;
    }

    private static void configureModules(Map<String, List<IForestryModule>> modules) {
        ForestryModule info;
        IForestryModule module;
        Iterator iterator;
        boolean changed;
        Configuration config;
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        HashSet<ResourceLocation> toLoad = new HashSet<ResourceLocation>();
        HashSet<IForestryModule> modulesToLoad = new HashSet<IForestryModule>();
        ImmutableList allModules = ImmutableList.copyOf((Collection)modules.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        for (IModuleContainer container : moduleContainers.values()) {
            String containerID = container.getID();
            List<IForestryModule> containerModules = modules.get(containerID);
            config = container.getModulesConfig();
            config.load();
            config.addCustomCategoryComment(CONFIG_CATEGORY, "Disabling these modules can greatly change how the mod functions.\nYour mileage may vary, please report any issues.");
            IForestryModule coreModule = ModuleManager.getModuleCore(containerModules);
            if (coreModule != null) {
                containerModules.remove(coreModule);
                containerModules.add(0, coreModule);
            } else {
                Log.debug("Could not find core module for the module container: {}", containerID);
            }
            Iterator<IForestryModule> iterator2 = containerModules.iterator();
            while (iterator2.hasNext()) {
                IForestryModule module2 = iterator2.next();
                if (!container.isAvailable()) {
                    iterator2.remove();
                    Log.info("Module disabled: {}", module2);
                    continue;
                }
                if (module2.canBeDisabled()) {
                    if (!container.isModuleEnabled(module2)) {
                        configDisabledModules.add(module2);
                        iterator2.remove();
                        Log.info("Module disabled: {}", module2);
                        continue;
                    }
                    if (!module2.isAvailable()) {
                        iterator2.remove();
                        Log.info("Module {} failed to load: {}", module2, module2.getFailMessage());
                        continue;
                    }
                }
                ForestryModule info2 = module2.getClass().getAnnotation(ForestryModule.class);
                toLoad.add(new ResourceLocation(containerID, info2.moduleID()));
                modulesToLoad.add(module2);
            }
        }
        do {
            changed = false;
            iterator = modulesToLoad.iterator();
            while (iterator.hasNext()) {
                module = (IForestryModule)iterator.next();
                Set<ResourceLocation> dependencies = module.getDependencyUids();
                if (toLoad.containsAll(dependencies)) continue;
                iterator.remove();
                changed = true;
                info = module.getClass().getAnnotation(ForestryModule.class);
                String moduleId = info.moduleID();
                toLoad.remove(new ResourceLocation(moduleId));
                Log.warning("Module {} is missing dependencies: {}", moduleId, dependencies);
            }
        } while (changed);
        block4: do {
            changed = false;
            iterator = modulesToLoad.iterator();
            while (iterator.hasNext()) {
                module = (IForestryModule)iterator.next();
                if (!sortedModules.keySet().containsAll(module.getDependencyUids())) continue;
                iterator.remove();
                ForestryModule info3 = module.getClass().getAnnotation(ForestryModule.class);
                sortedModules.put(new ResourceLocation(info3.containerID(), info3.moduleID()), module);
                changed = true;
                continue block4;
            }
        } while (changed);
        for (IModuleContainer container : moduleContainers.values()) {
            config = container.getModulesConfig();
            if (!config.hasChanged()) continue;
            config.save();
        }
        loadedModules.addAll(sortedModules.values());
        unloadedModules.addAll((Collection<IForestryModule>)allModules);
        unloadedModules.removeAll(sortedModules.values());
        for (IModuleContainer container : moduleContainers.values()) {
            Collection loadedModules = sortedModules.values().stream().filter(m -> {
                ForestryModule info = m.getClass().getAnnotation(ForestryModule.class);
                return info.containerID().equals(container.getID());
            }).collect(Collectors.toList());
            Collection unloadedModules = ModuleManager.unloadedModules.stream().filter(m -> {
                ForestryModule info = m.getClass().getAnnotation(ForestryModule.class);
                return info.containerID().equals(container.getID());
            }).collect(Collectors.toList());
            container.onConfiguredModules(loadedModules, unloadedModules);
        }
        ForestryAPI.enabledModules = new HashSet<ResourceLocation>();
        for (IForestryModule module3 : sortedModules.values()) {
            info = module3.getClass().getAnnotation(ForestryModule.class);
            ForestryAPI.enabledModules.add(new ResourceLocation(info.containerID(), info.moduleID()));
        }
        Locale.setDefault(locale);
    }

    public static void runSetup() {
        Map<String, List<IForestryModule>> forestryModules = ForestryPluginUtil.getForestryModules();
        moduleHandler = (CommonModuleHandler)DistExecutor.runForDist(() -> ClientModuleHandler::new, () -> CommonModuleHandler::new);
        ModuleManager.configureModules(forestryModules);
    }

    public static CommonModuleHandler getModuleHandler() {
        Preconditions.checkNotNull((Object)moduleHandler);
        return moduleHandler;
    }

    public static void serverStarting(MinecraftServer server) {
        CommandDispatcher dispatcher = server.func_195571_aL().func_197054_a();
        loadedModules.stream().map(IForestryModule::register).filter(Objects::nonNull).forEach(arg_0 -> ((CommandDispatcher)dispatcher).register(arg_0));
    }
}

