/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.api.core.IFeatureSubtype;
import forestry.api.core.IItemSubtype;
import forestry.modules.features.FeatureItem;
import forestry.modules.features.FeatureTable;
import forestry.modules.features.IFeatureRegistry;
import forestry.modules.features.IItemFeature;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import net.minecraft.item.Item;

public class FeatureItemTable<I extends Item, R extends IItemSubtype, C extends IItemSubtype>
extends FeatureTable<Builder<I, R, C>, FeatureItem<I>, R, C> {
    public FeatureItemTable(Builder<I, R, C> builder) {
        super(builder);
    }

    @Override
    protected FeatureItem<I> createFeature(Builder<I, R, C> builder, R rowType, C columnType) {
        return builder.registry.item(() -> (Item)builder.constructor.apply(rowType, columnType), builder.getIdentifier((IFeatureSubtype)rowType, (IFeatureSubtype)columnType));
    }

    public Collection<I> getBlocks() {
        return this.featureByTypes.values().stream().map(IItemFeature::item).collect(Collectors.toList());
    }

    public static class Builder<I extends Item, R extends IItemSubtype, C extends IItemSubtype>
    extends FeatureTable.Builder<R, C, FeatureItemTable<I, R, C>> {
        private final IFeatureRegistry registry;
        private final BiFunction<R, C, I> constructor;

        public Builder(IFeatureRegistry registry, BiFunction<R, C, I> constructor) {
            super(registry);
            this.registry = registry;
            this.constructor = constructor;
        }

        @Override
        public FeatureItemTable<I, R, C> create() {
            return new FeatureItemTable(this);
        }
    }
}

