/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.api.core.IBlockProvider;
import forestry.core.proxy.Proxies;
import forestry.modules.features.IItemFeature;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.state.Property;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface IBlockFeature<B extends Block, I extends BlockItem>
extends IItemFeature<I>,
IBlockProvider<B, I> {
    default public B block() {
        Block block = this.getBlock();
        if (block == null) {
            throw new IllegalStateException("Called feature getter method before content creation.");
        }
        return (B)block;
    }

    @Override
    default public Collection<B> collect() {
        return Collections.singleton(this.block());
    }

    default public <T extends Block> T cast() {
        return (T)this.block();
    }

    public void setBlock(B var1);

    public Supplier<B> getBlockConstructor();

    @Override
    @Nullable
    default public Supplier<I> getItemConstructor() {
        if (!this.hasBlock()) {
            return null;
        }
        Function<B, I> itemBlockConstructor = this.getItemBlockConstructor();
        if (itemBlockConstructor == null) {
            return null;
        }
        return () -> (BlockItem)itemBlockConstructor.apply(this.block());
    }

    @Nullable
    public Function<B, I> getItemBlockConstructor();

    @Override
    default public void create() {
        Supplier<B> blockConstructor = this.getBlockConstructor();
        Block block = (Block)blockConstructor.get();
        block.setRegistryName(this.getModId(), this.getIdentifier());
        this.setBlock(block);
        Function<B, I> constructor = this.getItemBlockConstructor();
        if (constructor != null) {
            BlockItem item = (BlockItem)constructor.apply(block);
            if (item.getRegistryName() == null && block.getRegistryName() != null) {
                item.setRegistryName(block.getRegistryName());
            }
            this.setItem(item);
        }
    }

    @Override
    default public <T extends IForgeRegistryEntry<T>> void register(RegistryEvent.Register<T> event) {
        IItemFeature.super.register(event);
        IForgeRegistry registry = event.getRegistry();
        Class superType = registry.getRegistrySuperType();
        if (Block.class.isAssignableFrom(superType) && this.hasBlock()) {
            registry.register(this.block());
            Proxies.common.registerBlock((Block)this.block());
        }
    }

    public BlockState defaultState();

    public <V extends Comparable<V>> BlockState with(Property<V> var1, V var2);
}

