/*
 * Decompiled with CFR 0.152.
 */
package forestry.modules.features;

import forestry.api.core.ITileTypeProvider;
import forestry.modules.features.IModFeature;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface ITileTypeFeature<T extends TileEntity>
extends IModFeature,
ITileTypeProvider<T> {
    @Override
    default public void create() {
        TileEntityType tileEntityType = this.getTileTypeConstructor().func_206865_a(null);
        tileEntityType.setRegistryName(this.getModId(), this.getIdentifier());
        this.setTileType(tileEntityType);
    }

    default public <R extends IForgeRegistryEntry<R>> void register(RegistryEvent.Register<R> event) {
        IForgeRegistry registry = event.getRegistry();
        Class superType = registry.getRegistrySuperType();
        if (TileEntityType.class.isAssignableFrom(superType) && this.hasTileType()) {
            registry.register(this.tileType());
        }
    }

    @Override
    default public TileEntityType<T> tileType() {
        TileEntityType tileType = this.getTileType();
        if (tileType == null) {
            throw new IllegalStateException("Called feature getter method before content creation.");
        }
        return tileType;
    }

    public void setTileType(TileEntityType<T> var1);

    public TileEntityType.Builder<T> getTileTypeConstructor();
}

