/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.gui.widgets;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import forestry.api.core.tooltips.ToolTip;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IForestrySpeciesRoot;
import forestry.api.genetics.alleles.IAlleleForestrySpecies;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.widgets.Widget;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.utils.SoundUtil;
import forestry.sorting.gui.GuiGeneticFilter;
import forestry.sorting.gui.ISelectableProvider;
import forestry.sorting.gui.widgets.SelectionWidget;
import genetics.api.GeneticsAPI;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.root.IRootDefinition;
import genetics.utils.AlleleUtils;
import genetics.utils.RootUtils;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;

public class SpeciesWidget
extends Widget
implements ISelectableProvider<IAlleleSpecies> {
    private static final ImmutableMap<IAlleleSpecies, ItemStack> ITEMS = SpeciesWidget.createEntries();
    private final ImmutableSet<IAlleleSpecies> entries;
    private final Direction facing;
    private final int index;
    private final boolean active;
    private final GuiGeneticFilter gui;

    public SpeciesWidget(WidgetManager manager, int xPos, int yPos, Direction facing, int index, boolean active, GuiGeneticFilter gui) {
        super(manager, xPos, yPos);
        this.facing = facing;
        this.index = index;
        this.active = active;
        this.gui = gui;
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (IRootDefinition definition : GeneticsAPI.apiInstance.getRoots().values()) {
            if (!definition.isPresent() || !(definition.get() instanceof IForestrySpeciesRoot)) continue;
            IForestrySpeciesRoot root = (IForestrySpeciesRoot)definition.get();
            IBreedingTracker tracker = root.getBreedingTracker((IWorld)manager.minecraft.field_71441_e, manager.minecraft.field_71439_g.func_146103_bH());
            for (String uid : tracker.getDiscoveredSpecies()) {
                IAllele allele = AlleleUtils.getAllele(uid).orElse(null);
                if (!(allele instanceof IAlleleSpecies)) continue;
                IAlleleSpecies species = (IAlleleSpecies)allele;
                entries.add((Object)species);
            }
        }
        this.entries = entries.build();
    }

    @Override
    public void draw(MatrixStack transform, int startY, int startX) {
        int x = this.xPos + startX;
        int y = this.yPos + startY;
        IFilterLogic logic = this.gui.getLogic();
        IAlleleSpecies allele = (IAlleleSpecies)logic.getGenomeFilter(this.facing, this.index, this.active);
        if (allele != null) {
            GuiUtil.drawItemStack(this.manager.gui, (ItemStack)ITEMS.getOrDefault((Object)allele, (Object)ItemStack.field_190927_a), x, y);
        }
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        if (this.gui.selection.isSame(this)) {
            textureManager.func_110577_a(SelectionWidget.TEXTURE);
            this.gui.func_238474_b_(transform, x - 1, y - 1, 212, 0, 18, 18);
        }
    }

    @Override
    public ImmutableSet<IAlleleSpecies> getEntries() {
        return this.entries;
    }

    @Override
    public void onSelect(@Nullable IAlleleSpecies selectable) {
        IFilterLogic logic = this.gui.getLogic();
        if (logic.setGenomeFilter(this.facing, this.index, this.active, selectable)) {
            logic.sendToServer(this.facing, (short)this.index, this.active, selectable);
        }
        if (this.gui.selection.isSame(this)) {
            this.gui.onModuleClick(this);
        }
        SoundUtil.playButtonClick();
    }

    @Override
    public void draw(GuiForestry gui, IAlleleSpecies selectable, MatrixStack transform, int y, int x) {
        GuiUtil.drawItemStack(gui, (ItemStack)ITEMS.getOrDefault((Object)selectable, (Object)ItemStack.field_190927_a), x, y);
    }

    @Override
    public ITextComponent getName(IAlleleSpecies selectable) {
        return selectable.getDisplayName();
    }

    @Override
    @Nullable
    public ToolTip getToolTip(int mouseX, int mouseY) {
        IFilterLogic logic = this.gui.getLogic();
        IAlleleForestrySpecies allele = (IAlleleForestrySpecies)logic.getGenomeFilter(this.facing, this.index, this.active);
        if (allele == null) {
            return null;
        }
        ToolTip tooltip = new ToolTip();
        tooltip.add(this.getName(allele));
        return tooltip;
    }

    @Override
    public void handleMouseClick(double mouseX, double mouseY, int mouseButton) {
        Optional<IIndividual> optional;
        ItemStack stack = this.gui.getMinecraft().field_71439_g.field_71071_by.func_70445_o();
        if (!stack.func_190926_b() && (optional = RootUtils.getIndividual(stack)).isPresent()) {
            IIndividual individual = optional.get();
            IGenome genome = individual.getGenome();
            this.onSelect(mouseButton == 0 ? genome.getPrimary() : genome.getSecondary());
            return;
        }
        if (mouseButton == 1) {
            this.onSelect(null);
        } else {
            SoundUtil.playButtonClick();
            this.gui.onModuleClick(this);
        }
    }

    private static ImmutableMap<IAlleleSpecies, ItemStack> createEntries() {
        ImmutableMap.Builder entries = ImmutableMap.builder();
        for (IRootDefinition definition : GeneticsAPI.apiInstance.getRoots().values()) {
            if (!definition.isPresent() || !(definition.get() instanceof IForestrySpeciesRoot)) continue;
            IForestrySpeciesRoot root = (IForestrySpeciesRoot)definition.get();
            for (IIndividual individual : root.getIndividualTemplates()) {
                IAlleleSpecies species = individual.getGenome().getPrimary();
                ItemStack itemStack = root.getTypes().createStack(root.templateAsIndividual(root.getTemplates().getTemplate(species.getRegistryName().toString())), root.getIconType());
                entries.put((Object)species, (Object)itemStack);
            }
        }
        return entries.build();
    }
}

