/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.gui;

import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.slots.SlotFilteredInventory;
import forestry.storage.features.BackpackContainers;
import forestry.storage.inventory.ItemInventoryBackpack;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class ContainerBackpack
extends ContainerItemInventory<ItemInventoryBackpack> {
    private final Size size;

    public static ContainerBackpack fromNetwork(int windowID, PlayerInventory inv, PacketBuffer extraData) {
        Size size = (Size)extraData.func_179257_a(Size.class);
        ItemStack parent = extraData.func_150791_c();
        return new ContainerBackpack(windowID, inv.field_70458_d, size, parent);
    }

    public ContainerBackpack(int windowID, PlayerEntity player, Size size, ItemStack parent) {
        super(windowID, new ItemInventoryBackpack(player, size.getSize(), parent), player.field_71071_by, 8, 11 + size.startY + size.rows * 18, BackpackContainers.BACKPACK.containerType());
        this.size = size;
        for (int j = 0; j < size.rows; ++j) {
            for (int k = 0; k < size.columns; ++k) {
                int slot = k + j * size.columns;
                this.func_75146_a(new SlotFilteredInventory(this.inventory, slot, size.startX + k * 18, size.startY + j * 18));
            }
        }
    }

    public Size getSize() {
        return this.size;
    }

    public static enum Size {
        DEFAULT(3, 5, 44, 19),
        T2(5, 9, 8, 8);

        final int rows;
        final int columns;
        final int startX;
        final int startY;

        private Size(int rows, int columns, int startX, int startY) {
            this.rows = rows;
            this.columns = columns;
            this.startX = startX;
            this.startY = startY;
        }

        public int getSize() {
            return this.rows * this.columns;
        }
    }
}

