/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import forestry.worktable.recipes.RecipeMemory;
import forestry.worktable.tiles.TileWorktable;
import java.io.IOException;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PacketWorktableMemoryUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    private final RecipeMemory recipeMemory;

    public PacketWorktableMemoryUpdate(TileWorktable worktable) {
        this.pos = worktable.func_174877_v();
        this.recipeMemory = worktable.getMemory();
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.WORKTABLE_MEMORY_UPDATE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        this.recipeMemory.writeData(data);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, PlayerEntity player) throws IOException {
            BlockPos pos = data.func_179259_c();
            TileWorktable tile = TileUtil.getTile((IBlockReader)player.field_70170_p, pos, TileWorktable.class);
            if (tile != null) {
                tile.getMemory().readData(data);
            }
        }
    }
}

