/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.network.packets;

import forestry.core.network.ForestryPacket;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.IForestryPacketHandlerClient;
import forestry.core.network.PacketBufferForestry;
import forestry.core.network.PacketIdClient;
import forestry.core.tiles.TileUtil;
import forestry.worktable.recipes.MemorizedRecipe;
import forestry.worktable.tiles.TileWorktable;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PacketWorktableRecipeUpdate
extends ForestryPacket
implements IForestryPacketClient {
    private final BlockPos pos;
    @Nullable
    private final MemorizedRecipe recipe;

    public PacketWorktableRecipeUpdate(TileWorktable worktable) {
        this.pos = worktable.func_174877_v();
        this.recipe = worktable.getCurrentRecipe();
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.WORKTABLE_CRAFTING_UPDATE;
    }

    @Override
    protected void writeData(PacketBufferForestry data) {
        data.func_179255_a(this.pos);
        data.writeStreamable(this.recipe);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Handler
    implements IForestryPacketHandlerClient {
        @Override
        public void onPacketData(PacketBufferForestry data, PlayerEntity player) throws IOException {
            BlockPos pos = data.func_179259_c();
            MemorizedRecipe recipe = data.readStreamable(MemorizedRecipe::new);
            TileUtil.actOnTile((IWorldReader)player.field_70170_p, pos, TileWorktable.class, tile -> tile.setCurrentRecipe(recipe));
        }
    }
}

