/*
 * Decompiled with CFR 0.152.
 */
package genetics.alleles;

import genetics.alleles.AlleleTemplateBuilder;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.alleles.IAlleleTemplateBuilder;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.individual.IKaryotype;
import genetics.api.root.IIndividualRoot;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class AlleleTemplate
implements IAlleleTemplate {
    private final IAllele[] alleles;
    private final IKaryotype karyotype;

    public AlleleTemplate(IAllele[] alleles, IKaryotype karyotype) {
        this.alleles = alleles;
        this.karyotype = karyotype;
    }

    @Override
    public IAllele get(IChromosomeType type) {
        return this.alleles[type.getIndex()];
    }

    @Override
    public IAllele[] alleles() {
        return Arrays.copyOf(this.alleles, this.alleles.length);
    }

    @Override
    public int size() {
        return this.alleles.length;
    }

    @Override
    public IAlleleTemplate copy() {
        return new AlleleTemplate(this.alleles(), this.karyotype);
    }

    @Override
    public IAlleleTemplateBuilder createBuilder() {
        return new AlleleTemplateBuilder(this.karyotype, this.alleles());
    }

    @Override
    public IKaryotype getKaryotype() {
        return this.karyotype;
    }

    @Override
    public <I extends IIndividual> I toIndividual(IIndividualRoot<I> root, @Nullable IAlleleTemplate inactiveTemplate) {
        return root.templateAsIndividual(this.alleles, inactiveTemplate == null ? null : inactiveTemplate.alleles());
    }

    @Override
    public IGenome toGenome(@Nullable IAlleleTemplate inactiveTemplate) {
        return this.karyotype.templateAsGenome(this.alleles, inactiveTemplate == null ? null : inactiveTemplate.alleles());
    }

    @Override
    public IChromosome[] toChromosomes(@Nullable IAlleleTemplate inactiveTemplate) {
        return this.karyotype.templateAsChromosomes(this.alleles, inactiveTemplate == null ? null : inactiveTemplate.alleles());
    }

    public String toString() {
        return Arrays.toString(this.alleles);
    }
}

