/*
 * Decompiled with CFR 0.152.
 */
package genetics.api;

import genetics.api.IGeneTemplate;
import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.alleles.IAlleleTemplateBuilder;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import genetics.api.individual.IIndividual;
import genetics.api.individual.IIndividualBuilder;
import genetics.api.individual.IKaryotype;
import genetics.api.organism.IOrganism;
import genetics.api.organism.IOrganismHandler;
import genetics.api.organism.IOrganismType;
import genetics.api.root.IDisplayHelper;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IRootDefinition;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface IGeneticFactory {
    public IAlleleTemplateBuilder createTemplateBuilder(IKaryotype var1);

    public IAlleleTemplateBuilder createTemplateBuilder(IKaryotype var1, IAllele[] var2);

    public IAlleleTemplate createTemplate(IKaryotype var1, IAllele[] var2);

    public IGenome createGenome(IKaryotype var1, CompoundNBT var2);

    public IGenome createGenome(IKaryotype var1, IChromosome[] var2);

    public IChromosome createChromosome(IAllele var1, IChromosomeType var2);

    public IChromosome createChromosome(IAllele var1, IAllele var2, IChromosomeType var3);

    public <I extends IIndividual> IOrganism<I> createOrganism(ItemStack var1, IOrganismType var2, IRootDefinition<? extends IIndividualRoot<I>> var3);

    public <I extends IIndividual> IOrganismHandler<I> createOrganismHandler(IRootDefinition<? extends IIndividualRoot<I>> var1, Supplier<ItemStack> var2);

    public <I extends IIndividual> IDisplayHelper<I> createDisplayHelper(IIndividualRoot<I> var1);

    public IGeneTemplate createGeneTemplate();

    public <I extends IIndividual> IIndividualBuilder<I> createIndividualBuilder(I var1);
}

