/*
 * Decompiled with CFR 0.152.
 */
package genetics.api.individual;

import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.alleles.IAlleleValue;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IChromosomeAllele;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IChromosomeValue;
import genetics.api.individual.IGenomeWrapper;
import genetics.api.individual.IKaryotype;
import net.minecraft.nbt.CompoundNBT;

public interface IGenome {
    public IChromosome[] getChromosomes();

    default public IAlleleSpecies getPrimary() {
        return this.getPrimary(IAlleleSpecies.class);
    }

    default public IAlleleSpecies getSecondary() {
        return this.getSecondary(IAlleleSpecies.class);
    }

    public <A extends IAlleleSpecies> A getPrimary(Class<? extends A> var1);

    public <A extends IAlleleSpecies> A getSecondary(Class<? extends A> var1);

    public IAllele getActiveAllele(IChromosomeType var1);

    public <V> IAlleleValue<V> getActiveAllele(IChromosomeValue<V> var1);

    public <A extends IAllele> A getActiveAllele(IChromosomeAllele<A> var1);

    public <A extends IAllele> A getActiveAllele(IChromosomeAllele<A> var1, A var2);

    public <A extends IAllele> A getActiveAllele(IChromosomeType var1, Class<? extends A> var2);

    public <A extends IAllele> A getActiveAllele(IChromosomeType var1, Class<? extends A> var2, A var3);

    public <V> V getActiveValue(IChromosomeType var1, Class<? extends V> var2);

    public <V> V getActiveValue(IChromosomeType var1, Class<? extends V> var2, V var3);

    public <V> V getActiveValue(IChromosomeValue<V> var1);

    public <V> V getActiveValue(IChromosomeValue<V> var1, V var2);

    public IAllele getInactiveAllele(IChromosomeType var1);

    public <V> IAlleleValue<V> getInactiveAllele(IChromosomeValue<V> var1);

    public <A extends IAllele> A getInactiveAllele(IChromosomeAllele<A> var1);

    public <A extends IAllele> A getInactiveAllele(IChromosomeAllele<A> var1, A var2);

    public <A extends IAllele> A getInactiveAllele(IChromosomeType var1, Class<? extends A> var2);

    public <A extends IAllele> A getInactiveAllele(IChromosomeType var1, Class<? extends A> var2, A var3);

    public <V> V getInactiveValue(IChromosomeType var1, Class<? extends V> var2);

    public <V> V getInactiveValue(IChromosomeType var1, Class<? extends V> var2, V var3);

    public <V> V getInactiveValue(IChromosomeValue<V> var1);

    public <V> V getInactiveValue(IChromosomeValue<V> var1, V var2);

    public IChromosome getChromosome(IChromosomeType var1);

    public IAllele[][] getAlleles();

    public IAllele[] getActiveAlleles();

    public IAllele[] getInactiveAlleles();

    public boolean isGeneticEqual(IGenome var1);

    public boolean isPureBred(IChromosomeType var1);

    public boolean isPureBred();

    public IKaryotype getKaryotype();

    public <W extends IGenomeWrapper> W asWrapper(Class<? extends W> var1);

    public CompoundNBT writeToNBT(CompoundNBT var1);
}

