/*
 * Decompiled with CFR 0.152.
 */
package genetics.individual;

import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleTemplate;
import genetics.api.alleles.IAlleleTemplateBuilder;
import genetics.api.individual.IChromosome;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IGenome;
import genetics.api.individual.IKaryotype;
import genetics.individual.Chromosome;
import genetics.individual.Genome;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Karyotype
implements IKaryotype {
    private final String uid;
    private final IChromosomeType[] chromosomeTypes;
    private final IChromosomeType speciesType;
    private final Function<IAlleleTemplateBuilder, IAlleleTemplate> defaultTemplateSupplier;
    private final BiFunction<IKaryotype, IAllele[], IAlleleTemplateBuilder> templateFactory;
    @Nullable
    private IAlleleTemplate defaultTemplate = null;
    @Nullable
    private IGenome defaultGenome = null;

    public Karyotype(String uid, List<IChromosomeType> chromosomeTypes, IChromosomeType speciesType, BiFunction<IKaryotype, IAllele[], IAlleleTemplateBuilder> templateFactory, Function<IAlleleTemplateBuilder, IAlleleTemplate> defaultTemplateSupplier) {
        this.uid = uid;
        this.speciesType = speciesType;
        this.chromosomeTypes = new IChromosomeType[chromosomeTypes.size()];
        this.templateFactory = templateFactory;
        Iterator<IChromosomeType> iterator = chromosomeTypes.iterator();
        while (iterator.hasNext()) {
            IChromosomeType key;
            this.chromosomeTypes[key.getIndex()] = key = iterator.next();
        }
        this.defaultTemplateSupplier = defaultTemplateSupplier;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public IChromosomeType[] getChromosomeTypes() {
        return this.chromosomeTypes;
    }

    @Override
    public boolean contains(IChromosomeType type) {
        return Arrays.asList(this.chromosomeTypes).contains(type);
    }

    @Override
    public IChromosomeType getSpeciesType() {
        return this.speciesType;
    }

    @Override
    public IAlleleTemplate getDefaultTemplate() {
        if (this.defaultTemplate == null) {
            this.defaultTemplate = this.defaultTemplateSupplier.apply(this.createEmptyTemplate());
        }
        return this.defaultTemplate;
    }

    @Override
    public int size() {
        return this.chromosomeTypes.length;
    }

    @Override
    public IGenome getDefaultGenome() {
        if (this.defaultGenome == null) {
            this.defaultGenome = this.getDefaultTemplate().toGenome();
        }
        return this.defaultGenome;
    }

    @Override
    public IAlleleTemplateBuilder createTemplate() {
        return this.getDefaultTemplate().createBuilder();
    }

    @Override
    public IAlleleTemplateBuilder createTemplate(IAllele[] alleles) {
        return this.templateFactory.apply(this, alleles);
    }

    @Override
    public IAlleleTemplateBuilder createEmptyTemplate() {
        return this.templateFactory.apply(this, new IAllele[this.chromosomeTypes.length]);
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] templateActive, @Nullable IAllele[] templateInactive) {
        IChromosome[] chromosomes = new Chromosome[this.chromosomeTypes.length];
        for (int i = 0; i < this.chromosomeTypes.length; ++i) {
            chromosomes[i] = templateInactive == null ? Chromosome.create(templateActive[i], this.chromosomeTypes[i]) : Chromosome.create(templateActive[i], templateInactive[i], this.chromosomeTypes[i]);
        }
        return chromosomes;
    }

    @Override
    public IGenome templateAsGenome(IAllele[] templateActive, @Nullable IAllele[] templateInactive) {
        return new Genome((IKaryotype)this, this.templateAsChromosomes(templateActive, templateInactive));
    }
}

