/*
 * Decompiled with CFR 0.152.
 */
package genetics.root;

import genetics.api.alleles.IAllele;
import genetics.api.alleles.IAlleleSpecies;
import genetics.api.individual.IChromosomeType;
import genetics.api.individual.IIndividual;
import genetics.api.individual.IKaryotype;
import genetics.api.mutation.IMutation;
import genetics.api.mutation.IMutationContainer;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.ComponentKeys;
import genetics.utils.AlleleUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class MutationContainer<I extends IIndividual, M extends IMutation>
implements IMutationContainer<I, M> {
    private final List<M> mutations = new LinkedList<M>();
    private final IIndividualRoot<I> root;

    public MutationContainer(IIndividualRoot<I> root) {
        this.root = root;
    }

    @Override
    public IIndividualRoot<I> getRoot() {
        return this.root;
    }

    @Override
    public boolean registerMutation(M mutation) {
        IChromosomeType speciesType = this.root.getKaryotype().getSpeciesType();
        IAlleleSpecies firstParent = mutation.getFirstParent();
        IAlleleSpecies secondParent = mutation.getSecondParent();
        IAllele resultSpecies = mutation.getTemplate()[speciesType.getIndex()];
        if (AlleleUtils.isBlacklisted(resultSpecies) || AlleleUtils.isBlacklisted(firstParent) || AlleleUtils.isBlacklisted(secondParent)) {
            return false;
        }
        this.mutations.add(mutation);
        return true;
    }

    @Override
    public List<M> getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(this.mutations);
        }
        return this.mutations;
    }

    @Override
    public List<M> getCombinations(IAllele other) {
        ArrayList<IMutation> combinations = new ArrayList<IMutation>();
        for (IMutation mutation : this.getMutations(false)) {
            if (!mutation.isPartner(other)) continue;
            combinations.add(mutation);
        }
        return combinations;
    }

    @Override
    public List<M> getResultantMutations(IAllele other) {
        IKaryotype karyotype = this.root.getKaryotype();
        ArrayList<IMutation> resultants = new ArrayList<IMutation>();
        int speciesIndex = karyotype.getSpeciesType().getIndex();
        for (IMutation mutation : this.getMutations(false)) {
            IAllele speciesAllele;
            IAllele[] template = mutation.getTemplate();
            if (template.length <= speciesIndex || (speciesAllele = template[speciesIndex]) != other) continue;
            resultants.add(mutation);
        }
        return resultants;
    }

    @Override
    public List<M> getCombinations(IAlleleSpecies parentFirst, IAlleleSpecies parentSecond, boolean shuffle) {
        ArrayList<IMutation> combinations = new ArrayList<IMutation>();
        ResourceLocation parentSpecies = parentSecond.getRegistryName();
        for (IMutation mutation : this.getMutations(shuffle)) {
            IAllele partner;
            if (!mutation.isPartner(parentFirst) || !(partner = mutation.getPartner(parentFirst)).getRegistryName().equals((Object)parentSpecies)) continue;
            combinations.add(mutation);
        }
        return combinations;
    }

    @Override
    public Collection<M> getPaths(IAllele result, IChromosomeType chromosomeType) {
        ArrayList<IMutation> paths = new ArrayList<IMutation>();
        for (IMutation mutation : this.getMutations(false)) {
            IAllele[] template = mutation.getTemplate();
            IAllele mutationResult = template[chromosomeType.getIndex()];
            if (mutationResult != result) continue;
            paths.add(mutation);
        }
        return paths;
    }

    @Override
    public ComponentKey<IMutationContainer> getKey() {
        return ComponentKeys.MUTATIONS;
    }
}

