/*
 * Decompiled with CFR 0.152.
 */
package genetics.utils;

import genetics.api.GeneticsAPI;
import genetics.api.individual.IIndividual;
import genetics.api.root.IIndividualRoot;
import genetics.api.root.IRootDefinition;
import genetics.api.root.components.ComponentKey;
import genetics.api.root.components.IRootComponent;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class RootUtils {
    private RootUtils() {
    }

    public static boolean hasRoot(ItemStack stack) {
        return GeneticsAPI.apiInstance.getRootHelper().getSpeciesRoot(stack).isPresent();
    }

    public static <R extends IIndividualRoot> IRootDefinition<R> getRoot(ItemStack stack) {
        return GeneticsAPI.apiInstance.getRootHelper().getSpeciesRoot(stack);
    }

    public static boolean isIndividual(ItemStack stack) {
        return GeneticsAPI.apiInstance.getRootHelper().isIndividual(stack);
    }

    public static Optional<IIndividual> getIndividual(ItemStack stack) {
        return GeneticsAPI.apiInstance.getRootHelper().getIndividual(stack);
    }

    @Nullable
    public static IIndividual getIndividualOrNull(ItemStack stack) {
        return RootUtils.getIndividual(stack).orElse(null);
    }

    @Nullable
    public static IIndividual getIndividualOr(ItemStack stack, IIndividual fallback) {
        return RootUtils.getIndividual(stack).orElse(fallback);
    }

    public static <C extends IRootComponent> C getComponent(IIndividual individual, ComponentKey<C> key) {
        return individual.getRoot().getComponent(key);
    }
}

