/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.block;

import com.infinityraider.infinitylib.block.IInfinityBlock;
import com.infinityraider.infinitylib.block.property.InfProperty;
import com.infinityraider.infinitylib.block.property.InfPropertyConfiguration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class BlockBase
extends Block
implements IInfinityBlock {
    private final String internalName;

    public BlockBase(String name, AbstractBlock.Properties properties) {
        super(properties);
        this.internalName = name;
        this.func_180632_j(this.getPropertyConfiguration().defineDefault((BlockState)this.func_176194_O().func_177621_b()));
    }

    protected final void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        this.getPropertyConfiguration().fillStateContainer(builder);
    }

    protected abstract InfPropertyConfiguration getPropertyConfiguration();

    @Deprecated
    public final BlockState func_185499_a(BlockState state, Rotation rot) {
        return this.getPropertyConfiguration().handleRotation(state, rot);
    }

    @Deprecated
    public final BlockState func_185471_a(BlockState state, Mirror mirror) {
        return this.getPropertyConfiguration().handleMirror(state, mirror);
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        if (this.getPropertyConfiguration().isWaterLoggable() && InfProperty.Defaults.waterlogged().fetch(state).booleanValue()) {
            return Fluids.field_204546_a.func_207204_a(false);
        }
        if (this.getPropertyConfiguration().isLavaLoggable() && InfProperty.Defaults.lavalogged().fetch(state).booleanValue()) {
            return Fluids.field_204547_b.func_207204_a(false);
        }
        if (this.getPropertyConfiguration().isFluidLoggable()) {
            return InfProperty.Defaults.fluidlogged().fetch(state).getFluid().func_207188_f();
        }
        return super.func_204507_t(state);
    }

    @Deprecated
    public BlockState func_196271_a(BlockState ownState, Direction dir, BlockState otherState, IWorld world, BlockPos pos, BlockPos otherPos) {
        Fluid fluid;
        if (this.getPropertyConfiguration().isWaterLoggable() && InfProperty.Defaults.waterlogged().fetch(ownState).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (this.getPropertyConfiguration().isLavaLoggable() && InfProperty.Defaults.lavalogged().fetch(ownState).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204547_b, Fluids.field_204547_b.func_205569_a((IWorldReader)world));
        }
        if (this.getPropertyConfiguration().isFluidLoggable() && (fluid = InfProperty.Defaults.fluidlogged().fetch(ownState).getFluid()) != Fluids.field_204541_a) {
            world.func_205219_F_().func_205360_a(pos, (Object)fluid, fluid.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(ownState, dir, otherState, world, pos, otherPos);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    @Nonnull
    public String getInternalName() {
        return this.internalName;
    }

    public final BlockState fluidlog(BlockState state, World world, BlockPos pos) {
        FluidState fluid;
        if (this.getPropertyConfiguration().isWaterLoggable()) {
            fluid = world.func_204610_c(pos);
            state = InfProperty.Defaults.waterlogged().apply(state, fluid.func_206886_c() == Fluids.field_204546_a);
        }
        if (this.getPropertyConfiguration().isLavaLoggable()) {
            fluid = world.func_204610_c(pos);
            state = InfProperty.Defaults.lavalogged().apply(state, fluid.func_206886_c() == Fluids.field_204547_b);
        }
        if (this.getPropertyConfiguration().isFluidLoggable()) {
            fluid = world.func_204610_c(pos);
            state = InfProperty.Defaults.fluidlogged().apply(state, InfProperty.FluidLogged.get(fluid));
        }
        return state;
    }

    public boolean addToInventoryOrDrop(ItemStack stack, World world, BlockPos pos, @Nullable PlayerEntity player) {
        if (player != null && player.func_191521_c(stack)) {
            return true;
        }
        ItemEntity entity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        return world.func_217376_c((Entity)entity);
    }
}

