/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules.playerstate;

import com.infinityraider.infinitylib.modules.playerstate.State;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerStateHandler {
    private static final PlayerStateHandler INSTANCE = new PlayerStateHandler();
    private final HashMap<UUID, State> states = new HashMap();

    public static PlayerStateHandler getInstance() {
        return INSTANCE;
    }

    private PlayerStateHandler() {
    }

    State getState(PlayerEntity player) {
        if (!this.states.containsKey(player.func_110124_au())) {
            this.states.put(player.func_110124_au(), new State(player));
        }
        return this.states.get(player.func_110124_au());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onProjectileImpactEvent(ProjectileImpactEvent event) {
        PlayerEntity player;
        Entity hit;
        if (event.getRayTraceResult().func_216346_c() == RayTraceResult.Type.ENTITY && (hit = ((EntityRayTraceResult)event.getRayTraceResult()).func_216348_a()) instanceof PlayerEntity && this.getState(player = (PlayerEntity)hit).isEthereal()) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityHurtEvent(LivingHurtEvent event) {
        PlayerEntity player;
        if (event.getEntityLiving() instanceof PlayerEntity && this.getState(player = (PlayerEntity)event.getEntityLiving()).isInvulnerable()) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerRenderPreEvent(RenderPlayerEvent.Pre event) {
        this.cancelRenderEvent((RenderPlayerEvent)event);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerRenderPostEvent(RenderPlayerEvent.Post event) {
        this.cancelRenderEvent((RenderPlayerEvent)event);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void cancelRenderEvent(RenderPlayerEvent event) {
        if (this.getState(event.getPlayer()).isInvisible()) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityTargetingEvent(LivingSetAttackTargetEvent event) {
        LivingEntity target = event.getTarget();
        LivingEntity attacker = event.getEntityLiving();
        if (target == null || attacker == null || !(target instanceof PlayerEntity) || !(attacker instanceof LivingEntity)) {
            return;
        }
        if (this.getState((PlayerEntity)target).isUndetectable()) {
            if (attacker instanceof MobEntity) {
                MobEntity mob = (MobEntity)attacker;
                mob.func_213395_q(false);
                mob.func_70624_b(null);
            }
            attacker.func_70604_c(null);
        }
    }
}

