/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render;

import com.google.common.collect.ImmutableMap;
import java.util.function.Function;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;

public class DefaultTransforms {
    private static final TransformationMatrix flipX = new TransformationMatrix(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null);
    public static final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> BLOCK = DefaultTransforms.generateBlockTransform();
    public static final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> ITEM = DefaultTransforms.generateItemTransform();

    private static ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> generateBlockTransform() {
        TransformationMatrix thirdperson = DefaultTransforms.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f);
        ImmutableMap.Builder transform = new ImmutableMap.Builder();
        transform.put((Object)ItemCameraTransforms.TransformType.GUI, (Object)DefaultTransforms.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f));
        transform.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)DefaultTransforms.get(0.0f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f));
        transform.put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)DefaultTransforms.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        transform.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson);
        transform.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)DefaultTransforms.leftify(thirdperson));
        transform.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)DefaultTransforms.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f));
        transform.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)DefaultTransforms.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f));
        return transform.build();
    }

    private static ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> generateItemTransform() {
        TransformationMatrix thirdperson = DefaultTransforms.get(0.0f, 3.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.55f);
        TransformationMatrix firstperson = DefaultTransforms.get(1.13f, 3.2f, 1.13f, 0.0f, -90.0f, 25.0f, 0.68f);
        ImmutableMap.Builder transform = new ImmutableMap.Builder();
        transform.put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)DefaultTransforms.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.5f));
        transform.put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)DefaultTransforms.get(0.0f, 13.0f, 7.0f, 0.0f, 180.0f, 0.0f, 1.0f));
        transform.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)thirdperson);
        transform.put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)DefaultTransforms.leftify(thirdperson));
        transform.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)firstperson);
        transform.put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)DefaultTransforms.leftify(firstperson));
        return transform.build();
    }

    private static TransformationMatrix get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TransformationMatrix(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), new Quaternion(ax, ay, az, true), new Vector3f(s, s, s), null);
    }

    private static TransformationMatrix leftify(TransformationMatrix transform) {
        return flipX.compose(transform.blockCornerToCenter()).compose(flipX).blockCenterToCorner();
    }

    public static final Matrix4f getBlockMatrix(ItemCameraTransforms.TransformType type) {
        if (BLOCK.containsKey((Object)type)) {
            return ((TransformationMatrix)BLOCK.get((Object)type)).func_227988_c_();
        }
        return TransformationMatrix.func_227983_a_().func_227988_c_();
    }

    public static final Matrix4f getItemMatrix(ItemCameraTransforms.TransformType type) {
        if (ITEM.containsKey((Object)type)) {
            return ((TransformationMatrix)ITEM.get((Object)type)).func_227988_c_();
        }
        return TransformationMatrix.func_227983_a_().func_227988_c_();
    }

    public static interface Transformer
    extends Function<ItemCameraTransforms.TransformType, Matrix4f> {
    }
}

