/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.infinityraider.infinitylib.InfinityLib;
import com.infinityraider.infinitylib.utility.ReflectionStreams;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static <T> void forEachValueIn(@Nonnull Object from, @Nonnull Class<T> type, @Nonnull Consumer<T> consumer) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(type);
        Objects.requireNonNull(consumer);
        Object target = from instanceof Class ? null : from;
        ReflectionHelper.forEachFieldIn(from, field -> {
            try {
                field.setAccessible(true);
                Object obj = field.get(target);
                if (obj != null && type.isAssignableFrom(obj.getClass())) {
                    consumer.accept(type.cast(obj));
                }
            }
            catch (IllegalAccessException e) {
                InfinityLib.instance.getLogger().warn("ReflectionHelper.forEachIn() Skipping Field: \"{0}\" in Class: \"{1}\"!", field.getName(), from.getClass().getCanonicalName());
            }
        });
    }

    public static <T, A extends Annotation> void forEachValueIn(@Nonnull Object from, @Nonnull Class<T> type, @Nonnull Class<A> annotation, @Nonnull BiConsumer<T, A> consumer) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(type);
        Objects.requireNonNull(annotation);
        Objects.requireNonNull(consumer);
        Object target = from instanceof Class ? null : from;
        ReflectionHelper.forEachFieldIn(from, annotation, (field, anno) -> {
            try {
                field.setAccessible(true);
                Object obj = field.get(target);
                if (obj != null && type.isAssignableFrom(obj.getClass())) {
                    consumer.accept(type.cast(obj), anno);
                }
            }
            catch (IllegalAccessException e) {
                InfinityLib.instance.getLogger().warn("ReflectionHelper.forEachIn() Skipping Field: \"{0}\" in Class: \"{1}\"!", field.getName(), from.getClass().getCanonicalName());
            }
        });
    }

    public static <A extends Annotation> void forEachFieldIn(@Nonnull Object from, @Nonnull Class<A> annotation, @Nonnull BiConsumer<Field, A> consumer) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(annotation);
        Objects.requireNonNull(consumer);
        ReflectionStreams.streamAccessibleFields(from).filter(f -> f.isAnnotationPresent(annotation)).forEach(f -> consumer.accept((Field)f, (Object)f.getAnnotation(annotation)));
    }

    public static void forEachFieldIn(@Nonnull Object from, @Nonnull Consumer<Field> consumer) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(consumer);
        ReflectionStreams.streamAccessibleFields(from).forEach(consumer);
    }

    public static boolean hasConstructorFor(@Nonnull Class<?> clazz, Class<?> ... types) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(types);
        try {
            Constructor<?> constructor = clazz.getConstructor(types);
            return constructor != null;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public static <T> Optional<T> attemptInstantiate(@Nonnull Class<T> clazz, Object ... parameters) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(parameters);
        Class[] types = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            types[i] = parameters[i].getClass();
        }
        try {
            return Optional.of(clazz.getConstructor(types).newInstance(parameters));
        }
        catch (IllegalAccessException | SecurityException e) {
            InfinityLib.instance.getLogger().debug("Unable to access constructor for class {0}!", clazz.getName());
        }
        catch (IllegalArgumentException e) {
            InfinityLib.instance.getLogger().error("The following error should not have occured!", new Object[0]);
            InfinityLib.instance.getLogger().error(e.getLocalizedMessage(), new Object[0]);
        }
        catch (InstantiationException e) {
            InfinityLib.instance.getLogger().debug("Unable to instantiate class {0}!\nGiven reason is \"{1}\"!", clazz.getName(), e.getMessage());
        }
        catch (InvocationTargetException e) {
            InfinityLib.instance.getLogger().debug("The constructor for class {0} threw an error!\nGiven reason is: \"{1}\"!", clazz.getName(), e.getCause());
        }
        catch (NoSuchMethodException e) {
            InfinityLib.instance.getLogger().debug("The class {0} does not provide a constructor with parameters of types: {1}!", clazz.getName(), Arrays.asList(types));
        }
        return Optional.empty();
    }
}

