/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractBannerBlock;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.BlockState;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CeilingBannerBlockTile
extends TileEntity
implements INameable {
    @Nullable
    private ITextComponent name;
    @Nullable
    private DyeColor baseColor = DyeColor.WHITE;
    @Nullable
    private ListNBT itemPatterns;
    private boolean receivedData;
    @Nullable
    private List<Pair<BannerPattern, DyeColor>> patterns;

    public CeilingBannerBlockTile() {
        super((TileEntityType)ModRegistry.CEILING_BANNER_TILE.get());
    }

    public CeilingBannerBlockTile(DyeColor p_i47731_1_) {
        this();
        this.baseColor = p_i47731_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fromItem(ItemStack p_195534_1_, DyeColor p_195534_2_) {
        this.itemPatterns = BannerTileEntity.func_230139_a_((ItemStack)p_195534_1_);
        this.baseColor = p_195534_2_;
        this.patterns = null;
        this.receivedData = true;
        this.name = p_195534_1_.func_82837_s() ? p_195534_1_.func_200301_q() : null;
    }

    public ITextComponent func_200200_C_() {
        return this.name != null ? this.name : new TranslationTextComponent("block.minecraft.banner");
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.name;
    }

    public void setCustomName(ITextComponent p_213136_1_) {
        this.name = p_213136_1_;
    }

    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        if (this.itemPatterns != null) {
            p_189515_1_.func_218657_a("Patterns", (INBT)this.itemPatterns);
        }
        if (this.name != null) {
            p_189515_1_.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.name));
        }
        return p_189515_1_;
    }

    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        if (p_230337_2_.func_150297_b("CustomName", 8)) {
            this.name = ITextComponent.Serializer.func_240643_a_((String)p_230337_2_.func_74779_i("CustomName"));
        }
        this.baseColor = this.func_145830_o() ? ((AbstractBannerBlock)this.func_195044_w().func_177230_c()).func_196285_M_() : null;
        this.itemPatterns = p_230337_2_.func_150295_c("Patterns", 10);
        this.patterns = null;
        this.receivedData = true;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 6, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Pair<BannerPattern, DyeColor>> getPatterns() {
        if (this.patterns == null && this.receivedData) {
            this.patterns = BannerTileEntity.func_230138_a_((DyeColor)this.getBaseColor(() -> ((CeilingBannerBlockTile)this).func_195044_w()), (ListNBT)this.itemPatterns);
        }
        return this.patterns;
    }

    public ItemStack getItem(BlockState state) {
        ItemStack itemstack = new ItemStack((IItemProvider)BannerBlock.func_196287_a((DyeColor)this.getBaseColor(() -> state)));
        if (this.itemPatterns != null && !this.itemPatterns.isEmpty()) {
            itemstack.func_190925_c("BlockEntityTag").func_218657_a("Patterns", (INBT)this.itemPatterns.func_74737_b());
        }
        if (this.name != null) {
            itemstack.func_200302_a(this.name);
        }
        return itemstack;
    }

    public DyeColor getBaseColor(Supplier<BlockState> p_195533_1_) {
        if (this.baseColor == null) {
            this.baseColor = ((AbstractBannerBlock)p_195533_1_.get().func_177230_c()).func_196285_M_();
        }
        return this.baseColor;
    }
}

