/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.particles;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FeatherParticle
extends SpriteTexturedParticle {
    private float rotSpeed;
    private boolean fallingAnim = false;
    private int animationOffset;
    private float rotOffset = 0.0f;
    private int groundTime = 0;

    private FeatherParticle(ClientWorld worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double speedX, double speedY, double speedZ) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn);
        this.field_70544_f = (float)((double)this.field_70544_f * (1.3125 + (double)this.field_187136_p.nextFloat() * 0.15));
        this.field_70547_e = 120 + this.field_187136_p.nextInt(20);
        this.rotSpeed = 2.0f * (0.045f + this.field_187136_p.nextFloat() * 0.08f) + ((float)speedY - 0.03f);
        this.animationOffset = (int)(this.field_187136_p.nextFloat() * ((float)Math.PI * 2) / this.rotSpeed);
        this.field_187129_i = speedX + ((double)this.field_187136_p.nextFloat() * 2.0 - 1.0) * (double)0.008f;
        this.field_187130_j = speedY;
        this.field_187131_k = speedZ + ((double)this.field_187136_p.nextFloat() * 2.0 - 1.0) * (double)0.008f;
    }

    public void setRotOffset(int spriteIndex) {
        int[] offsets = new int[]{-45, 0, 16};
        this.rotOffset = (float)((double)offsets[spriteIndex] * Math.PI / 180.0);
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (++this.field_70546_d >= this.field_70547_e || this.groundTime > 20) {
            this.func_187112_i();
        } else {
            this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            this.field_187129_i *= (double)0.98f;
            this.field_187131_k *= (double)0.98f;
            this.field_187130_j -= (double)0.002f;
            this.field_187130_j = Math.max(this.field_187130_j, (double)-0.008f);
            if (this.field_187132_l && this.field_187130_j > 0.0) {
                this.field_187132_l = false;
            }
            if (!this.field_187132_l) {
                if (!this.fallingAnim) {
                    float rot = (float)((double)((float)(this.field_70546_d + this.animationOffset) * this.rotSpeed) % (Math.PI * 2));
                    if (this.field_187130_j <= 0.0 && rot > 0.0f && (double)rot < 0.01 + (double)(this.rotSpeed * 2.0f)) {
                        this.fallingAnim = true;
                        if (this.field_190015_G > 6.0f) {
                            // empty if block
                        }
                        this.animationOffset = this.field_70546_d;
                    }
                    this.field_190015_G = this.field_190014_F;
                    this.field_190014_F = rot;
                } else if (this.fallingAnim) {
                    int t = this.field_70546_d - this.animationOffset;
                    double freq = 1.0f - this.rotSpeed;
                    double k = 20.0;
                    float min = (float)(freq / 2.0);
                    float amp = (float)((freq - (double)min) * Math.exp((double)(-t) / k)) + min;
                    float w = (float)((double)this.rotSpeed / freq);
                    this.field_190015_G = this.field_190014_F;
                    this.field_190014_F = MathHelper.func_76126_a((float)((float)t * w)) * amp;
                }
            } else {
                ++this.groundTime;
                this.field_190015_G = this.field_190014_F;
                this.field_187130_j = 0.0;
            }
        }
    }

    public void func_225606_a_(IVertexBuilder builder, ActiveRenderInfo info, float partialTicks) {
        Quaternion quaternion;
        Vector3d vector3d = info.func_216785_c();
        float f = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - vector3d.func_82615_a());
        float f1 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - vector3d.func_82617_b());
        float f2 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - vector3d.func_82616_c());
        if (this.field_190014_F == 0.0f) {
            quaternion = info.func_227995_f_();
        } else {
            quaternion = new Quaternion(info.func_227995_f_());
            float p = 57.29578f;
            float f3 = MathHelper.func_219805_h((float)partialTicks, (float)((this.rotOffset + this.field_190015_G) * p), (float)((this.rotOffset + this.field_190014_F) * p));
            quaternion.func_195890_a(Vector3f.field_229183_f_.func_229193_c_(f3 / p));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.func_214905_a(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.func_217561_b(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(f4);
            vector3f.func_195904_b(f, f1, f2);
        }
        float f7 = this.func_217563_c();
        float f8 = this.func_217564_d();
        float f5 = this.func_217562_e();
        float f6 = this.func_217560_f();
        int j = this.func_189214_a(partialTicks);
        double offset = 0.125;
        builder.func_225582_a_((double)avector3f[0].func_195899_a(), (double)avector3f[0].func_195900_b() + offset, (double)avector3f[0].func_195902_c()).func_225583_a_(f8, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        builder.func_225582_a_((double)avector3f[1].func_195899_a(), (double)avector3f[1].func_195900_b() + offset, (double)avector3f[1].func_195902_c()).func_225583_a_(f8, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        builder.func_225582_a_((double)avector3f[2].func_195899_a(), (double)avector3f[2].func_195900_b() + offset, (double)avector3f[2].func_195902_c()).func_225583_a_(f7, f5).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
        builder.func_225582_a_((double)avector3f[3].func_195899_a(), (double)avector3f[3].func_195900_b() + offset, (double)avector3f[3].func_195902_c()).func_225583_a_(f7, f6).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(j).func_181675_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            FeatherParticle particle2 = new FeatherParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            particle2.func_70538_b(1.0f, 1.0f, 1.0f);
            int i = particle2.field_187136_p.nextInt(3);
            particle2.setRotOffset(i);
            particle2.func_217567_a(this.spriteSet.func_217591_a(i, 2));
            return particle2;
        }
    }
}

