/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Alignment;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTextElement
extends Pane {
    private static final int FILTERING_ROUNDING = 50;
    private static final float FILTERING_THRESHOLD = 0.02f;
    public static final double DEFAULT_TEXT_SCALE = 1.0;
    public static final Alignment DEFAULT_TEXT_ALIGNMENT = Alignment.MIDDLE_LEFT;
    public static final int DEFAULT_TEXT_COLOR = 0xFFFFFF;
    public static final boolean DEFAULT_TEXT_SHADOW = false;
    public static final boolean DEFAULT_TEXT_WRAP = false;
    public static final int DEFAULT_TEXT_LINESPACE = 0;
    public static final int SIZE_FOR_UNLIMITED_ELEMENTS = 1000000;
    protected double textScale = 1.0;
    protected Alignment textAlignment = DEFAULT_TEXT_ALIGNMENT;
    protected int textColor = 0xFFFFFF;
    protected int textHoverColor = 0xFFFFFF;
    protected int textDisabledColor = 0xFFFFFF;
    protected boolean textShadow = false;
    protected boolean textWrap = false;
    protected int textLinespace = 0;
    protected List<IFormattableTextComponent> text;
    protected List<IReorderingProcessor> preparedText;
    protected int renderedTextWidth;
    protected int renderedTextHeight;
    protected int textOffsetX = 0;
    protected int textOffsetY = 0;
    protected int textWidth = this.width;
    protected int textHeight = this.height;

    public AbstractTextElement() {
        this(DEFAULT_TEXT_ALIGNMENT, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, false, false);
    }

    public AbstractTextElement(Alignment defaultTextAlignment, int defaultTextColor, int defaultTextHoverColor, int defaultTextDisabledColor, boolean defaultTextShadow, boolean defaultTextWrap) {
        this.textAlignment = defaultTextAlignment;
        this.textColor = defaultTextColor;
        this.textHoverColor = defaultTextHoverColor;
        this.textDisabledColor = defaultTextDisabledColor;
        this.textShadow = defaultTextShadow;
        this.textWrap = defaultTextWrap;
    }

    public AbstractTextElement(PaneParams params) {
        this(params, DEFAULT_TEXT_ALIGNMENT, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, false, false);
    }

    public AbstractTextElement(PaneParams params, Alignment defaultTextAlignment, int defaultTextColor, int defaultTextHoverColor, int defaultTextDisabledColor, boolean defaultTextShadow, boolean defaultTextWrap) {
        super(params);
        this.textAlignment = params.getEnum("textalign", Alignment.class, defaultTextAlignment);
        if (params.hasAttribute("color")) {
            this.setColors(params.getColor("color", defaultTextColor));
        } else {
            this.textColor = params.getColor("textcolor", defaultTextColor);
            this.textHoverColor = params.getColor("texthovercolor", defaultTextHoverColor);
            this.textDisabledColor = params.getColor("textdisabledcolor", defaultTextDisabledColor);
        }
        this.textShadow = params.getBoolean("shadow", defaultTextShadow);
        this.textWrap = params.getBoolean("wrap", defaultTextWrap);
        this.textScale = params.getDouble("textscale", this.textScale);
        this.textLinespace = params.getInteger("linespace", this.textLinespace);
        this.text = params.getMultilineText(params.hasAnyAttribute("label", "text"));
    }

    protected void recalcTextRendering() {
        if (this.textScale <= 0.0 || this.textWidth < 1 || this.textHeight < 1 || this.isTextEmpty()) {
            this.preparedText = Collections.emptyList();
            return;
        }
        int maxWidth = (int)((double)this.textWidth / this.textScale);
        this.preparedText = this.text.stream().flatMap(textBlock -> textBlock == StringTextComponent.field_240750_d_ ? Stream.of(textBlock.func_241878_f()) : this.mc.field_71466_p.func_238425_b_((ITextProperties)textBlock, maxWidth).stream()).collect(Collectors.toList());
        if (this.textWrap) {
            int maxHeight = (int)((double)this.textHeight / this.textScale) + 1;
            this.mc.field_71466_p.getClass();
            int lineHeight = 9 + this.textLinespace;
            this.preparedText = this.preparedText.subList(0, Math.min(this.preparedText.size(), maxHeight / lineHeight));
            this.renderedTextWidth = (int)((double)this.preparedText.stream().mapToInt(arg_0 -> ((FontRenderer)this.mc.field_71466_p).func_243245_a(arg_0)).max().orElse(maxWidth) * this.textScale);
            this.renderedTextHeight = (int)((double)(Math.min(this.preparedText.size() * lineHeight, maxHeight) - 1 - this.textLinespace) * this.textScale);
        } else {
            this.preparedText = this.preparedText.subList(0, 1);
            this.renderedTextWidth = (int)((double)this.mc.field_71466_p.func_243245_a(this.preparedText.get(0)) * this.textScale);
            this.mc.field_71466_p.getClass();
            this.renderedTextHeight = (int)((double)(9 - 1) * this.textScale);
        }
    }

    protected int getTextRenderingColor(double mx, double my) {
        return this.enabled ? (this.isPointInPane(mx, my) ? this.textHoverColor : this.textColor) : this.textDisabledColor;
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        if (this.preparedText.isEmpty()) {
            return;
        }
        int color = this.enabled ? (this.wasCursorInPane ? this.textHoverColor : this.textColor) : this.textDisabledColor;
        int offsetX = this.textOffsetX;
        int offsetY = this.textOffsetY;
        if (this.textAlignment.isRightAligned()) {
            offsetX += this.textWidth - this.renderedTextWidth;
        } else if (this.textAlignment.isHorizontalCentered()) {
            offsetX += (this.textWidth - this.renderedTextWidth) / 2;
        }
        if (this.textAlignment.isBottomAligned()) {
            offsetY += this.textHeight - this.renderedTextHeight;
        } else if (this.textAlignment.isVerticalCentered()) {
            offsetY += (this.textHeight - this.renderedTextHeight) / 2;
        }
        ms.func_227860_a_();
        ms.func_227861_a_((double)(this.x + offsetX), (double)(this.y + offsetY), 0.0);
        Matrix4f matrix4f = ms.func_227866_c_().func_227870_a_();
        Vector4f temp = new Vector4f(1.0f, 1.0f, 0.0f, 0.0f);
        temp.func_229372_a_(matrix4f);
        float oldScaleX = temp.func_195910_a();
        float oldScaleY = temp.func_195913_b();
        float newScaleX = (float)Math.round((double)oldScaleX * this.textScale * 50.0) / 50.0f;
        float newScaleY = (float)Math.round((double)oldScaleY * this.textScale * 50.0) / 50.0f;
        if (Math.abs((float)Math.round(newScaleX) - newScaleX) > 0.02f || Math.abs((float)Math.round(newScaleY) - newScaleY) > 0.02f) {
            ms.func_227862_a_((float)this.textScale, (float)this.textScale, 1.0f);
        } else {
            ms.func_227862_a_(newScaleX / oldScaleX, newScaleY / oldScaleY, 1.0f);
        }
        IRenderTypeBuffer.Impl drawBuffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        int lineShift = 0;
        for (IReorderingProcessor row : this.preparedText) {
            int xOffset = this.textAlignment.isRightAligned() ? (int)(((double)this.renderedTextWidth - (double)this.mc.field_71466_p.func_243245_a(row) * this.textScale) / this.textScale) : (this.textAlignment.isHorizontalCentered() ? (int)(((double)this.renderedTextWidth - (double)this.mc.field_71466_p.func_243245_a(row) * this.textScale) / 2.0 / this.textScale) : 0);
            this.mc.field_71466_p.func_238416_a_(row, (float)xOffset, (float)lineShift, color, this.textShadow, matrix4f, (IRenderTypeBuffer)drawBuffer, false, 0, 0xF000F0);
            this.mc.field_71466_p.getClass();
            lineShift += 9 + this.textLinespace;
        }
        drawBuffer.func_228461_a_();
        ms.func_227865_b_();
    }

    public Alignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(Alignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public double getTextScale() {
        return this.textScale;
    }

    public void setTextScale(double textScale) {
        this.textScale = textScale;
        this.recalcTextRendering();
    }

    public void setColors(int color) {
        this.setColors(color, color, color);
    }

    public void setColors(int textColor, int textDisabledColor, int textHoverColor) {
        this.textColor = textColor;
        this.textDisabledColor = textDisabledColor;
        this.textHoverColor = textHoverColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public int getTextHoverColor() {
        return this.textHoverColor;
    }

    public void setTextHoverColor(int textHoverColor) {
        this.textHoverColor = textHoverColor;
    }

    public int getTextDisabledColor() {
        return this.textDisabledColor;
    }

    public void setTextDisabledColor(int textDisabledColor) {
        this.textDisabledColor = textDisabledColor;
    }

    public int getTextLinespace() {
        return this.textLinespace;
    }

    public void setTextLinespace(int textLinespace) {
        this.textLinespace = textLinespace;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public boolean isTextWrap() {
        return this.textWrap;
    }

    public void setTextWrap(boolean textWrap) {
        this.textWrap = textWrap;
        this.recalcTextRendering();
    }

    @Nullable
    public List<IFormattableTextComponent> getTextAsList() {
        return this.text;
    }

    @Nullable
    public IFormattableTextComponent getText() {
        return this.isTextEmpty() ? null : this.text.get(0);
    }

    public void setTextOld(List<ITextComponent> text) {
        this.setText(text);
    }

    public void setText(List<IFormattableTextComponent> text) {
        this.text = text;
        this.recalcTextRendering();
    }

    public void setText(ITextComponent text) {
        this.setText((IFormattableTextComponent)text);
    }

    public void setText(IFormattableTextComponent text) {
        this.setText(Collections.singletonList(text));
    }

    public void clearText() {
        this.setText(Collections.emptyList());
    }

    @Nullable
    public String getTextAsStringStrict() {
        return this.isTextEmpty() ? null : this.text.get(0).getString();
    }

    @NotNull
    public String getTextAsString() {
        return this.isTextEmpty() ? "" : this.text.get(0).getString();
    }

    @Deprecated
    public void setText(String text) {
        this.setText((IFormattableTextComponent)new StringTextComponent(text));
    }

    public boolean isTextEmpty() {
        return this.text == null || this.text.stream().allMatch(t -> t.getString().isEmpty());
    }

    public int getRenderedTextWidth() {
        return this.renderedTextWidth;
    }

    public int getRenderedTextHeight() {
        return this.renderedTextHeight;
    }

    public List<IReorderingProcessor> getPreparedText() {
        return this.preparedText;
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.textWidth = this.width;
        this.textHeight = this.height;
        this.recalcTextRendering();
    }
}

