/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.Render;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityIcon
extends Pane {
    @Nullable
    private Entity entity;
    private int count = 1;
    private float yaw = 30.0f;
    private float pitch = -10.0f;
    private float headyaw = 0.0f;

    public EntityIcon() {
    }

    public EntityIcon(@NotNull PaneParams params) {
        super(params);
        String entityName = params.getString("entity");
        if (entityName != null) {
            this.setEntity(new ResourceLocation(entityName));
        }
        this.count = params.getInteger("count", this.count);
        this.yaw = params.getFloat("yaw", this.yaw);
        this.pitch = params.getFloat("pitch", this.pitch);
        this.headyaw = params.getFloat("head", this.headyaw);
    }

    public void setEntity(@NotNull ResourceLocation entityId) {
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(entityId);
        if (entityType != null) {
            this.setEntity(entityType);
        } else {
            this.resetEntity();
        }
    }

    public void setEntity(@NotNull EntityType<?> type) {
        Entity entity = type.func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
        if (entity != null) {
            this.setEntity(entity);
        } else {
            this.resetEntity();
        }
    }

    public void setEntity(@NotNull Entity entity) {
        this.entity = entity;
        this.setHoverPane(null);
    }

    public void resetEntity() {
        this.entity = null;
        this.setHoverPane(null);
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        if (this.entity != null) {
            ms.func_227860_a_();
            ms.func_227861_a_((double)this.x, (double)this.y, -50.0);
            AxisAlignedBB bb = this.entity.func_174813_aQ();
            float scale = (float)((double)this.getHeight() / bb.func_216360_c() / 1.5);
            int cx = this.getWidth() / 2;
            int by = this.getHeight();
            int offsetY = 2;
            Render.drawEntity(ms, cx, by - 2, scale, this.headyaw, this.yaw, this.pitch, this.entity);
            if (this.count != 1) {
                String s = String.valueOf(this.count);
                ms.func_227861_a_((double)this.getWidth(), (double)this.getHeight(), 100.0);
                ms.func_227862_a_(0.75f, 0.75f, 0.75f);
                IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                FontRenderer fontRenderer = this.mc.field_71466_p;
                float f = -4 - this.mc.field_71466_p.func_78256_a(s);
                this.mc.field_71466_p.getClass();
                fontRenderer.func_228079_a_(s, f, (float)(-9), 0xFFFFFF, true, ms.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                buffer.func_228461_a_();
            }
            ms.func_227865_b_();
        }
    }

    @Override
    public void onUpdate() {
        if (this.onHover == null && this.entity != null) {
            PaneBuilders.tooltipBuilder().hoverPane(this).build().setText(this.entity.func_145748_c_());
        }
    }
}

