/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blocks;

import com.ldtteam.structurize.api.blocks.IBlockCollection;
import com.ldtteam.structurize.api.blocks.IBlockList;
import com.ldtteam.structurize.blocks.CactusCollection;
import com.ldtteam.structurize.blocks.FloatingCarpetList;
import com.ldtteam.structurize.blocks.MultiBlock;
import com.ldtteam.structurize.blocks.PaperWallList;
import com.ldtteam.structurize.blocks.ShingleSlabList;
import com.ldtteam.structurize.blocks.decorative.BlockBarrel;
import com.ldtteam.structurize.blocks.decorative.BlockFloatingCarpet;
import com.ldtteam.structurize.blocks.decorative.BlockPaperWall;
import com.ldtteam.structurize.blocks.decorative.BlockShingle;
import com.ldtteam.structurize.blocks.decorative.BlockShingleSlab;
import com.ldtteam.structurize.blocks.decorative.BlockTimberFrame;
import com.ldtteam.structurize.blocks.schematic.BlockFluidSubstitution;
import com.ldtteam.structurize.blocks.schematic.BlockSolidSubstitution;
import com.ldtteam.structurize.blocks.schematic.BlockSubstitution;
import com.ldtteam.structurize.blocks.schematic.BlockTagSubstitution;
import com.ldtteam.structurize.blocks.types.BrickType;
import com.ldtteam.structurize.blocks.types.ShingleFaceType;
import com.ldtteam.structurize.blocks.types.TimberFrameType;
import com.ldtteam.structurize.items.ModItemGroups;
import com.ldtteam.structurize.items.ModItems;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class ModBlocks {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"structurize");
    public static final RegistryObject<BlockSubstitution> blockSubstitution;
    public static final RegistryObject<BlockSolidSubstitution> blockSolidSubstitution;
    public static final RegistryObject<BlockFluidSubstitution> blockFluidSubstitution;
    public static final RegistryObject<BlockTagSubstitution> blockTagSubstitution;
    public static final RegistryObject<MultiBlock> multiBlock;
    public static final RegistryObject<BlockBarrel> blockDecoBarrel_onside;
    public static final RegistryObject<BlockBarrel> blockDecoBarrel_standing;
    public static final IBlockCollection CACTI_BLOCKS;
    public static final List<IBlockCollection> BRICKS;
    public static final IBlockList<BlockPaperWall> paperWalls;
    public static final IBlockList<BlockFloatingCarpet> floatingCarpets;
    public static final List<TimberFrameType> timberFrames;
    public static final List<ShingleFaceType> shingles;
    public static final IBlockList<BlockShingleSlab> shingleSlabs;
    public static final ITag.INamedTag<Block> NULL_PLACEMENT;

    private ModBlocks() {
    }

    public static DeferredRegister<Block> getRegistry() {
        return BLOCKS;
    }

    public static List<BlockTimberFrame> getTimberFrames() {
        return ModBlocks.getBlocks(timberFrames);
    }

    public static List<BlockPaperWall> getPaperWalls() {
        return paperWalls.getBlocks();
    }

    public static List<BlockShingle> getShingles() {
        return ModBlocks.getBlocks(shingles);
    }

    public static List<BlockShingleSlab> getShingleSlabs() {
        return shingleSlabs.getBlocks();
    }

    public static List<BlockFloatingCarpet> getFloatingCarpets() {
        return floatingCarpets.getBlocks();
    }

    public static <B extends Block> List<B> getList(List<RegistryObject<B>> list) {
        return list.stream().map(RegistryObject::get).collect(Collectors.toList());
    }

    public static <B extends Block, L extends IBlockList<B>> List<B> getBlocks(List<L> list) {
        return list.stream().flatMap(type -> type.getBlocks().stream()).collect(Collectors.toList());
    }

    public static <B extends Block> RegistryObject<B> register(String name, Supplier<B> block, ItemGroup group) {
        RegistryObject registered = BLOCKS.register(name.toLowerCase(), block);
        ModItems.getRegistry().register(name.toLowerCase(), () -> new BlockItem((Block)registered.get(), new Item.Properties().func_200916_a(group)));
        return registered;
    }

    static {
        CACTI_BLOCKS = new CactusCollection();
        BRICKS = Arrays.asList(BrickType.values());
        paperWalls = new PaperWallList();
        floatingCarpets = new FloatingCarpetList();
        timberFrames = TimberFrameType.getAll();
        shingles = Arrays.asList(ShingleFaceType.values());
        shingleSlabs = new ShingleSlabList();
        NULL_PLACEMENT = BlockTags.func_199894_a((String)"structurize:null_placement");
        blockSubstitution = ModBlocks.register("blockSubstitution", BlockSubstitution::new, ModItemGroups.STRUCTURIZE);
        blockSolidSubstitution = ModBlocks.register("blockSolidSubstitution", BlockSolidSubstitution::new, ModItemGroups.STRUCTURIZE);
        blockFluidSubstitution = ModBlocks.register("blockFluidSubstitution", BlockFluidSubstitution::new, ModItemGroups.STRUCTURIZE);
        blockTagSubstitution = ModBlocks.register("blockTagSubstitution", BlockTagSubstitution::new, ModItemGroups.STRUCTURIZE);
        multiBlock = ModBlocks.register("multiblock", MultiBlock::new, ModItemGroups.STRUCTURIZE);
        blockDecoBarrel_onside = ModBlocks.register("blockbarreldeco_onside", BlockBarrel::new, ModItemGroups.STRUCTURIZE);
        blockDecoBarrel_standing = ModBlocks.register("blockbarreldeco_standing", BlockBarrel::new, ModItemGroups.STRUCTURIZE);
    }
}

