/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockout.Loader;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonHandler;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.OverlayView;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.api.util.Log;
import java.util.function.ObjIntConsumer;
import net.minecraft.util.text.IFormattableTextComponent;

public class DialogDoneCancel
extends OverlayView
implements ButtonHandler {
    public static final int CANCEL = 0;
    public static final int DONE = 1;
    private static final String DIALOG_OK_CANCEL_SUFFIX = ":gui/dialogdonecancel.xml";
    protected final Text titleLabel;
    protected final Text contentText;
    protected final Button doneButton;
    protected final Button cancelButton;
    protected ObjIntConsumer<DialogDoneCancel> handler;

    public DialogDoneCancel(Window window) {
        Loader.createFromXMLFile("structurize:gui/dialogdonecancel.xml", (View)this);
        this.titleLabel = this.findPaneOfTypeByID("title", Text.class);
        this.contentText = this.findPaneOfTypeByID("textcontent", Text.class);
        this.doneButton = this.findPaneOfTypeByID("done", Button.class);
        this.cancelButton = this.findPaneOfTypeByID("cancel", Button.class);
        this.doneButton.setHandler(this);
        this.cancelButton.setHandler(this);
        this.window = window;
    }

    public IFormattableTextComponent getTitleNew() {
        return this.titleLabel.getText();
    }

    @Deprecated
    public String getTitle() {
        return this.titleLabel.getTextAsString();
    }

    public void setTitle(IFormattableTextComponent title) {
        this.titleLabel.setText(title);
    }

    @Deprecated
    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public String getTextContent() {
        return this.contentText.getTextAsString();
    }

    public void setTextContent(String content) {
        this.contentText.setText(content);
    }

    @Override
    public void onButtonClicked(Button button) {
        this.setVisible(false);
        if (this.handler == null) {
            Log.getLogger().error("DialogDoneCancel does not have a handler.");
            return;
        }
        if (button == this.doneButton) {
            this.handler.accept(this, 1);
        } else {
            this.handler.accept(this, 0);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setPosition(0, 0);
            this.setSize(this.window.getInteriorWidth(), this.window.getInteriorHeight());
            this.putInside(this.window);
        }
        super.setVisible(visible);
    }

    public void open() {
        this.setVisible(true);
    }

    public void close() {
        this.setVisible(true);
    }

    public void setHandler(ObjIntConsumer<DialogDoneCancel> h) {
        this.handler = h;
    }
}

