/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.management.linksession;

import com.ldtteam.structurize.management.linksession.ChannelsEnum;
import com.ldtteam.structurize.management.linksession.LinkSession;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkSessionManager
implements INBTSerializable<CompoundNBT> {
    private static final String CHANNELS_TAG = "channels";
    public static final LinkSessionManager INSTANCE = new LinkSessionManager();
    private final HashMap<UUID, LinkSession> sessions = new HashMap();
    private final HashMap<UUID, HashMap<Integer, Boolean>> channels = new HashMap();
    private final HashMap<UUID, UUID> invites = new HashMap();

    public void createSession(@NotNull UUID ownerUUID) {
        this.sessions.put(ownerUUID, new LinkSession());
    }

    public boolean destroySession(@NotNull UUID ownerUUID) {
        return this.sessions.remove(ownerUUID) != null;
    }

    public List<UUID> getMembersOf(@NotNull UUID ownerUUID) {
        return this.sessions.get(ownerUUID) == null ? Collections.emptyList() : this.sessions.get(ownerUUID).getMembersUUID();
    }

    public List<String> getMembersNamesOf(@NotNull UUID ownerUUID) {
        return this.sessions.get(ownerUUID) == null ? Collections.emptyList() : this.sessions.get(ownerUUID).getMembersDisplayNames();
    }

    public List<String> getSessionNamesOf(@NotNull UUID memberUUID) {
        List ses = this.sessions.entrySet().stream().filter(en -> ((LinkSession)en.getValue()).isMember(memberUUID)).map(en -> ((LinkSession)en.getValue()).getMemberDisplayName((UUID)en.getKey())).collect(Collectors.toList());
        return ses.isEmpty() ? Collections.emptyList() : ses;
    }

    public Set<UUID> execute(@NotNull UUID memberUUID, @NotNull ChannelsEnum channel) {
        return this.sessions.entrySet().stream().filter(en -> ((LinkSession)en.getValue()).isMember(memberUUID)).flatMap(en -> this.getMembersOf((UUID)en.getKey()).stream()).filter(uuid -> !this.getMuteState((UUID)uuid, channel)).collect(Collectors.toSet());
    }

    public boolean addOrUpdateMemberInSession(@NotNull UUID ownerUUID, @NotNull UUID memberUUID, @Nullable String displayName) {
        if (this.sessions.containsKey(ownerUUID)) {
            this.sessions.get(ownerUUID).addOrUpdateMember(memberUUID, displayName);
            return true;
        }
        return false;
    }

    public boolean removeMemberOfSession(@NotNull UUID ownerUUID, @NotNull UUID memberUUID) {
        if (this.sessions.containsKey(ownerUUID)) {
            this.sessions.get(ownerUUID).removeMember(memberUUID);
            return true;
        }
        return false;
    }

    public void setMuteState(@NotNull UUID playerUUID, @NotNull ChannelsEnum channel, @NotNull boolean state) {
        if (!this.channels.containsKey(playerUUID)) {
            this.channels.put(playerUUID, new HashMap());
        }
        this.channels.get(playerUUID).put(channel.getID(), state);
    }

    public boolean getMuteState(@NotNull UUID playerUUID, @NotNull ChannelsEnum channel) {
        if (this.channels.containsKey(playerUUID) && this.channels.get(playerUUID).containsKey(channel.getID())) {
            return this.channels.get(playerUUID).get(channel.getID());
        }
        return false;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT out = new CompoundNBT();
        CompoundNBT channelz = new CompoundNBT();
        this.sessions.forEach((uuid, ls) -> out.func_218657_a(uuid.toString(), (INBT)ls.writeToNBT()));
        this.channels.forEach((uuid, ch) -> {
            CompoundNBT player = new CompoundNBT();
            ch.forEach((id, state) -> player.func_74757_a(String.valueOf(id), state.booleanValue()));
            channelz.func_218657_a(uuid.toString(), (INBT)player);
        });
        out.func_218657_a(CHANNELS_TAG, (INBT)channelz);
        return out;
    }

    public void deserializeNBT(@NotNull CompoundNBT in) {
        this.reset();
        CompoundNBT channelz = in.func_74775_l(CHANNELS_TAG);
        for (String key : channelz.func_150296_c()) {
            CompoundNBT playerTag = channelz.func_74775_l(key);
            UUID playerUUID = UUID.fromString(key);
            this.channels.put(playerUUID, new HashMap());
            for (String id : playerTag.func_150296_c()) {
                this.channels.get(playerUUID).put(Integer.valueOf(id), playerTag.func_74767_n(id));
            }
        }
        in.func_82580_o(CHANNELS_TAG);
        for (String key : in.func_150296_c()) {
            this.sessions.put(UUID.fromString(key), LinkSession.createFromNBT(in.func_74775_l(key)));
        }
    }

    public boolean createInvite(@NotNull UUID playerUUID, @NotNull UUID ownerUUID) {
        if (this.sessions.containsKey(ownerUUID)) {
            this.invites.put(playerUUID, ownerUUID);
            return true;
        }
        return false;
    }

    @Nullable
    public String hasInvite(@NotNull UUID playerUUID) {
        if (this.invites.containsKey(playerUUID)) {
            UUID ownerUUID = this.invites.get(playerUUID);
            if (this.sessions.containsKey(ownerUUID)) {
                return this.sessions.get(ownerUUID).getMemberDisplayName(ownerUUID);
            }
            this.invites.remove(playerUUID);
        }
        return null;
    }

    @Nullable
    public String consumeInvite(@NotNull UUID playerUUID, @Nullable String playerName) {
        if (!this.invites.containsKey(playerUUID)) {
            return null;
        }
        UUID ownerUUID = this.invites.get(playerUUID);
        this.invites.remove(playerUUID);
        if (!this.addOrUpdateMemberInSession(ownerUUID, playerUUID, playerName)) {
            return null;
        }
        return this.sessions.get(ownerUUID).getMemberDisplayName(ownerUUID);
    }

    @Nullable
    public String consumeInviteWithCheck(@NotNull UUID playerUUID, @Nullable String playerName, @NotNull UUID UUIDtoCheck) {
        if (this.invites.containsKey(playerUUID) && this.invites.get(playerUUID).equals(UUIDtoCheck)) {
            return this.consumeInvite(playerUUID, playerName);
        }
        return null;
    }

    private void reset() {
        this.channels.clear();
        this.sessions.clear();
        this.invites.clear();
    }
}

